package net.morilib.sh.builtin;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import net.morilib.sh.ShCommandExecuteTest;
import net.morilib.sh.ShFileSystemStub;

public class ShTouchTest extends ShCommandExecuteTest {

	static final SimpleDateFormat FMT =
		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	static void eqt(String s) {
		try {
			assertEquals(FMT.parse(s).getTime(),
					ShFileSystemStub.lastModified);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

	public void test001() {
		exe("touch -d '2013/01/02' 1.txt", 0);
		eqt("2013/01/02 00:00:00");
	}

	public void test002() {
		exe("touch --date='2013/01/04' 1.txt", 0);
		eqt("2013/01/04 00:00:00");
	}

	public void test003() {
		exe("touch -t 01050000 1.txt", 0);
		eqt("2013/01/05 00:00:00");
	}

	public void test004() {
		exe("touch -r reference 1.txt", 0);
		eqt("2013/01/03 00:00:00");
	}

	public void test005() {
		exe("touch --reference=reference 1.txt", 0);
		eqt("2013/01/03 00:00:00");
	}

	public void test006() {
		exe("touch -d '2013/01/06' notexist", 0);
		eot(o2r, "notexist");
		eot(o2r);
	}

}
