/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 * インデックスエラーです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkIndexException extends AwkRuntimeException {

	//
	private int indexno;

	/**
	 * 例外を発生します。
	 * 
	 * @param indexno インデックス番号
	 */
	public AwkIndexException(int indexno) {
		super();
		this.indexno = indexno;
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param indexno インデックス番号
	 * @param message メッセージ
	 */
	public AwkIndexException(int indexno, String message) {
		super(message);
		this.indexno = indexno;
	}

	/**
	 * インデックス番号を返します。
	 */
	public int getIndexno() {
		return indexno;
	}

}
