/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数s.checksumの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class SChecksum extends AwkBinaryArgs {

	protected SChecksum() {
		super("checksum");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		int c = a2 instanceof AwkUndefined ? 16 : a2.toIntExact();
		String s = a1.toString(ns);
		long m = 0;

		if(c < 1) {
			throw new AwkRuntimeException("natural number required");
		} else if(c > 32) {
			throw new AwkRuntimeException(
					"bit number must be less than 32");
		} else {
			for(int i = 0; i < s.length(); i++)  m += s.charAt(i);
		}
		return AwkInteger.valueOf(m & ((1l << c) - 1));
	}

}
