/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

/**
 * byte型のVectorIteratorを得ます。
 * <p>VectorIteratorは標準ライブラリのListIteratorに相当します。
 * 
 * @author MORIGUCHI, Yuichiro 2010/10/11
 */
public interface ByteVectorIterator extends ByteIterator {

	/**
	 * バイトを追加します。
	 * 
	 * @param v バイト
	 */
	public void addByte(byte v);

	/**
	 * バイトを追加します。
	 * 
	 * @param v バイト
	 * @throws IllegalArgumentException 値が0～255を超えたとき
	 */
	public void add(int v);

	/**
	 * 前にデータがあるときtrueを得ます。
	 * 
	 * @return 前にデータがあるときtrue
	 */
	public boolean hasPrevious();

	/**
	 * 次の要素の位置を得ます。
	 * 
	 * @return 次の要素の位置
	 */
	public int nextIndex();

	/**
	 * 前の要素を得ます。
	 * 
	 * @return 前の要素
	 */
	public byte previous();

	/**
	 * 前の要素の位置を得ます。
	 * 
	 * @return 前の要素の位置
	 */
	public int previousIndex();

	/**
	 * イテレータの場所にバイトをセットします。
	 * 
	 * @param v 値
	 */
	public void setByte(byte v);

	/**
	 * イテレータの場所にバイトをセットします。
	 * 
	 * @param v 値
	 * @throws IllegalArgumentException 値が0～255を超えたとき
	 */
	public void set(int v);

}
