/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.matrix;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/09/21
 */
public class LUDecomposedLMatrix extends AbstractImmutableDoubleMatrix {

	//
	private DoubleMatrix a;

	//
	/*package*/ LUDecomposedLMatrix(DoubleMatrix a) {
		this.a = a;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispNumberMatrix#get(int, int)
	 */
	public double get(int row, int column) {
		if(row > column) {
			return a.get(row, column);
		} else if(row == column) {
			return 1.0;
		} else {
			return 0.0;
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#rowSize()
	 */
	public int rowSize() {
		return a.rowSize();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#columnSize()
	 */
	public int columnSize() {
		return a.columnSize();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#determinant()
	 */
	public double determinant() {
		return 1.0;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#invert()
	 */
	public DoubleMatrix inv() {
		ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
		double x;

		for(int c = 1; c < columnSize(); c++) {
			for(int i = c; i < rowSize(); i++) {
				int j = i - c;

				x = 0.0;
				for(int k = j + 1; k <= i; k++) {
					x = x + r.get(i, k) * get(k, j);
				}
				// x.uminus(),mul(r.get(i, i))
				r.set(i, j, -x);
			}
		}
		return r;
	}

}
