/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.misc;

/**
 * int型のイテレータです。
 * 
 * @author MORIGUCHI, Yuichiro 2010/10/11
 */
public interface IntegerIterator {

	/**
	 * 次の要素があるときtrueを得ます。
	 * 
	 * @return 次の要素があるときtrue
	 */
	public boolean hasNext();

	/**
	 * 次の要素を得ます。
	 * 
	 * @return 次の要素
	 * @throws NoSuchElementException 次の要素がないとき
	 */
	public int next();

	/**
	 * 現在の要素を取り除きます。
	 * 
	 * @throws UnsupportedOperationException 操作がサポートされていないとき
	 */
	public void remove();

}
