/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.AwkSQLException;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkResultSet extends AwkValue implements AwkSQLCloseable {

	private ResultSet result;
	private AwkValue value = null;

	/**
	 * 
	 * @param rs
	 */
	public AwkResultSet(ResultSet rs) {
		result = rs;
	}

	private boolean setvalue() throws SQLException {
		ResultSetMetaData md;
		String s, v;
		AwkArray a;

		if(result.next()) {
			a  = new AwkArray();
			md = result.getMetaData();
			for(int i = 1; i <= md.getColumnCount(); i++) {
				s = md.getColumnName(i);
				v = result.getString(i);
				a.putArray(s, AwkString.valueOf(v));
			}
			value = a;
			return true;
		} else {
			return false;
		}
	}

	public Iterator<AwkValue> iterator() {
		return new Iterator<AwkValue>() {

			public boolean hasNext() {
				try {
					return value != null || setvalue();
				} catch(SQLException e) {
					throw new AwkSQLException(e);
				}
			}

			public AwkValue next() {
				AwkValue v;

				try {
					if(value == null && !setvalue()) {
						throw new NoSuchElementException();
					}
					v = value;
					value = null;
					return v;
				} catch (SQLException e) {
					throw new AwkSQLException(e);
				}
			}

			public void remove() {
				throw new UnsupportedOperationException();
			}

		};
	}

	public String toString(AwkNamespace ns) {
		return "<result set>";
	}

	public boolean toBoolean(AwkNamespace ns) {
		return true;
	}

	public Object toObject() {
		return result;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	public boolean isPositiveValue() {
		return false;
	}

	public boolean isZeroValue() {
		return false;
	}

	public boolean isNegativeValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public int compareTo(AwkValue v, AwkNamespace ns) {
		throw new AwkCastException(this + " is not comparable");
	}

	public void closeSQL() throws SQLException {
		result.close();
	}

}
