/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import net.morilib.awk.namespace.AwkNamespace;

/**
 * awkium未定義値のクラスです。<br />
 * 未定義値は、
 * <ol>
 * <li>整数0</li>
 * <li>空文字列</li>
 * <li>空の配列</li>
 * </ol>
 * と扱われます。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkUndefined extends AwkValue {

	/**
	 * 未定義値のインスタンスです。
	 */
	public static final AwkUndefined UNDEF = new AwkUndefined();

	private AwkUndefined() {}

	public double toFloat() {
		return 0.0;
	}

	public BigInteger toInteger() {
		return BigInteger.ZERO;
	}

	public Number toReal() {
		return BigInteger.ZERO;
	}

	public boolean toBoolean(AwkNamespace ns) {
		return false;
	}

	public Pattern toRegex() {
		return Pattern.compile("");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return "";
	}

	public AwkValue referArray(String v) {
		return this;
	}

	public AwkValue putArray(String k, AwkValue v) {
		AwkArray r = new AwkArray();

		r.putArray(k, v);
		return r;
	}

	public AwkValue deleteArray(String v) {
		return this;
	}

	public Set<String> keys() {
		return Collections.emptySet();
	}

	public Collection<AwkValue> values() {
		return Collections.emptyList();
	}

	public Set<Map.Entry<String, AwkValue>> entrySet() {
		return Collections.emptySet();
	}

	public Map<String, AwkValue> map() {
		return Collections.emptyMap();
	}

	public void clear() {
		// do nothing
	}

	public int size() {
		return 0;
	}

	public boolean contains(String k) {
		return false;
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	@Override
	public boolean isNegativeValue() {
		return false;
	}

	@Override
	public boolean isPositiveValue() {
		return false;
	}

	@Override
	public boolean isZeroValue() {
		return true;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	@Override
	public boolean isEmpty() {
		return true;
	}

	public boolean isArray() {
		return true;
	}

	public AwkArray toArray() {
		return new AwkArray();
	}

	public String toString(AwkNamespace ns) {
		return "";
	}

	public int compareTo(AwkValue o, AwkNamespace ns) {
//		return o instanceof AwkUndefined ? 0 : -1;
		return o.isEmpty() ? 0 : -1;
	}

}
