/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

import net.morilib.c.pre.parser.CpreToken;

/**
 * Cプリプロセッサの構文エラーの例外です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreSyntaxException extends CpreException {

	/**
	 * 例外を生成します。
	 * 
	 * @param lineno 行番号
	 * @param expect 期待したトークン
	 * @param actual 実際のトークン
	 */
	public CpreSyntaxException(int lineno, CpreToken expect,
			CpreToken actual) {
		super("line " + lineno +
				": expected " + expect + " but " + actual);
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param lineno 行番号
	 * @param expect 期待したトークン
	 * @param actual 実際のトークン
	 */
	public CpreSyntaxException(int lineno, String expect,
			CpreToken actual) {
		super("line " + lineno +
				": expected " + expect + " but " + actual);
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param lineno 行番号
	 * @param line   メッセージ
	 */
	public CpreSyntaxException(int lineno, String line) {
		super("line " + lineno + ": " + line);
	}

}
