/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

/**
 * Cプリプロセッサのユーティリティです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public final class CpreUtils {

	CpreUtils() {}

	/**
	 * Cマクロの識別子の最初の文字かを調べます。
	 * 
	 * @param c 文字
	 * @return 最初の文字のときtrue
	 */
	public static boolean isCMacroIdentifierStart(int c) {
		return (c >= 'A' && c <= 'Z' || c == '_' ||
				c >= 'a' && c <= 'z');
	}

	/**
	 * Cマクロの識別子の2文字目以降のの文字かを調べます。
	 * 
	 * @param c 文字
	 * @return 2文字目以降の文字のときtrue
	 */
	public static boolean isCMacroIdentifierPart(int c) {
		return (c >= 'A' && c <= 'Z' ||
				c >= '0' && c <= '9' || c == '_' ||
				c >= 'a' && c <= 'z');
	}

}
