/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

/**
 * Cプリプロセッサ式のトークンを表す基底クラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/16
 */
public class CpreToken {

	/**
	 * 式の終わりを表すエンドマーカです。
	 */
	public static final CpreToken ENDMARKER = new CpreToken("#");

	/**
	 * トークンの記述です。
	 */
	protected String desc;

	//
	CpreToken(String desc) {
		this.desc = desc;
	}

	/**
	 * 関係演算子の種類を得ます。
	 * 
	 * @return 関係演算子の種類
	 */
	public CpreOperatorType getRelation() {
		throw new RuntimeException();
	}

	/**
	 * 文字列・シンボル名を得ます。
	 * 
	 * @return 文字列またはシンボル名
	 */
	public String getString() {
		throw new RuntimeException();
	}

	/**
	 * 整数を得ます。
	 * 
	 * @return 整数
	 */
	public long getInteger() {
		throw new RuntimeException();
	}

	/**
	 * 浮動小数点を得ます。
	 * 
	 * @return 浮動小数点
	 */
	public double getFloat() {
		throw new RuntimeException();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return desc;
	}

}
