/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

/**
 * 1行のマッチをあらわすインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public interface SedLineMatcher {

	/**
	 * 行にマッチするかを調べます。
	 * 
	 * @param pa 正規表現エンジン
	 * @param s  1行
	 * @param lineno 行番号
	 * @param relno  相対行番号
	 * @param lastno 最後の行のときtrue
	 * @return マッチしたときtrue
	 */
	public boolean matches(SedPatternEngine pa, String s, long lineno,
			long relno, boolean lastno);

}
