/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShTee implements ShProcess {

	//
	private static final int BUFSIZE = 4096;

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		byte[] a = new byte[BUFSIZE];
		BufferedOutputStream[] ous;
		BufferedInputStream ins;
		boolean append = false;
		int k = 1, l;

		if(args[k].equals("-a") || args[k].equals("--append")) {
			append = true;
			k++;
		}

		ous    = new BufferedOutputStream[args.length - k + 1];
		ous[0] = new BufferedOutputStream(out);
		for(int i = 0; i < ous.length - 1; i++) {
			ous[i + 1] = new BufferedOutputStream(
					fs.getFile(args[i + k]).getPrintStream(append));
		}

		ins = new BufferedInputStream(in);
		while((l = ins.read(a)) >= 0) {
			for(int i = 0; i < ous.length; i++) {
				ous[i].write(a, 0, l);
			}
		}

		ous[0].flush();
		for(int i = 1; i < ous.length; i++)  ous[i].close();
		return 0;
	}

}
