/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.unix.misc.ParseDate;

public class ShTouch implements ShProcess {

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		java.util.Date d = new java.util.Date();
		boolean create = true;
		PrintStream ous;
		int k = 1;
		ShFile f;

		try {
			while(k < args.length) {
				if(args[k].equals("-c")) {
					create = false;
					k++;
				} else if(args[k].equals("-d") && ++k < args.length) {
					d = new java.util.Date(
							ParseDate.from(d, args[k++]));
				} else if(args[k].startsWith("--date=") &&
						args[k].length() > 7) {
					d = new java.util.Date(
							ParseDate.from(d, args[k++].substring(7)));
				} else if(args[k].equals("-r") && ++k < args.length) {
					d = new java.util.Date(
							fs.getFile(args[k++]).getLastModified());
				} else if(args[k].startsWith("--reference=") &&
						args[k].length() > 12) {
					d = new java.util.Date(fs.getFile(
							args[k++].substring(12))
							.getLastModified());
				} else if(args[k].equals("-t") && ++k < args.length) {
					d = ParseDate.parseMMDD(args[k++]);
				} else if(args[k].equals("-f")) {
					k++;
				} else {
					break;
				}
			}
		} catch(IllegalArgumentException e) {
			err.println("touch: invalid date");
			return 2;
		}

		for(int i = k; i < args.length; i++) {
			f = fs.getFile(args[k]);
			if(f.isExist()) {
				f.setLastModified(d.getTime());
			} else if(create) {
				ous = f.getPrintStream(true);
				ous.close();
			}
		}
		return 0;
	}

}
