/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/20
 */
public class ExtendAwkMTest extends AwkTestCase {

	public void testTerm() {
		eqc("-\"1+2i\"", -1, -2);
		eqc("\"1+2i\" + \"3+4i\"", 4, 6);
		eqc("\"3+4i\" - \"2+1i\"", 1, 3);
		eqf("\"1+2i\" + \"1-2i\"", 2);
	}

	public void testFactor() {
		eqc("\"3+4i\" * \"2+1i\"", 2, 11);
		eqf("\"4+4i\" / \"2+2i\"", 2);
	}

	public void testAbs001() {
		eqf("m.abs(m.c(3, 4))", 5.0);
		eqf("m.abs(\"3-4i\")", 5.0);
		eqa("m.abs(a.c(\"3-4i\", \"3+4i\"))", 5.0, 5.0);
	}

	public void testAngle001() {
		eqf("m.angle(1)", 0);
		eqf("m.angle(-1)", Math.PI);
		eqf("m.angle(m.c( 0,  1))", Math.PI / 2);
		eqf("m.angle(m.c( 1,  1))", Math.PI / 4);
		eqf("m.angle(m.c(-1,  1))", 3 * Math.PI / 4);
		eqf("m.angle(m.c( 1, -1))", -Math.PI / 4);
		eqf("m.angle(m.c(-1, -1))", -3 * Math.PI / 4);
		eqf("m.angle(\"1+1i\")", Math.PI / 4);
		eqa("m.angle(a.c(\"1+1i\", \"1-1i\"))", Math.PI / 4, -Math.PI / 4);
	}

	public void testConj001() {
		eqc("m.conj(m.c(3, 4))", 3.0, -4.0);
		eqc("m.conj(\"3-4i\")", 3.0, 4.0);
	}

	public void testIm001() {
		eqf("m.re(m.c(3, 4))", 3.0);
		eqf("m.re(\"3-4i\")", 3.0);
		eqa("m.re(a.c(\"3-4i\", \"4+4i\"))", 3.0, 4.0);
	}

	public void testRe001() {
		eqf("m.im(m.c(3, 4))", 4.0);
		eqf("m.im(\"3-4i\")", -4.0);
		eqa("m.im(a.c(\"2+3i\", \"3+4i\"))", 3.0, 4.0);
	}

}
