/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import net.morilib.awk.code.AwkExecutable;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/26
 */
public class ExtendAwkTTest extends AwkTestCase {

	static final SimpleDateFormat D =
		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");

	static long t(String s) {
		try {
			return D.parse(s).getTime();
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

	public void testTAttr() {
		long t = t("2013/02/01 12:34:56 789");

		eqs("t.era(" + t + ")", "AD");
		eqi("t.year(" + t + ")", 2013);
		eqi("t.month(" + t + ")", 2);
		eqi("t.day(" + t + ")", 1);
		eqi("t.week(" + t + ")", 6);
		eqi("t.dayofyear(" + t + ")", 32);
		eqi("t.hour(" + t + ")", 12);
		eqi("t.min(" + t + ")", 34);
		eqi("t.sec(" + t + ")", 56);
		eqi("t.millisec(" + t + ")", 789);
		eqi("t.zone(" + t + ")", 9);
	}

	public void testTToarray() {
		long t = t("2013/02/01 12:34:56 789");
		AwkExecutable e = pre("" +
				"{ a = t.toarray(" + t + ")\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 34 56 789 9");
		eot("AD 2013 2 1 6 32 12 34 56 789 9");
	}

	public void testTTime01() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1, 12, 34, 56, 789, 2)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 34 56 789 2");
		eot("AD 2013 2 1 6 32 5 34 56 789 9");
	}

	public void testTTime02() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1, 12, 34, 56, 789)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 34 56 789 9");
		eot("AD 2013 2 1 6 32 12 34 56 789 9");
	}

	public void testTTime03() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1, 12, 34, 56)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 34 0 0 9");
		eot("AD 2013 2 1 6 32 12 34 56 0 9");
	}

	public void testTTime04() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1, 12, 34)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 34 0 0 9");
		eot("AD 2013 2 1 6 32 12 34 0 0 9");
	}

	public void testTTime05() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1, 12)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 12 0 0 0 9");
		eot("AD 2013 2 1 6 32 12 0 0 0 9");
	}

	public void testTTime06() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2, 1)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 0 0 0 0 9");
		eot("AD 2013 2 1 6 32 0 0 0 0 9");
	}

	public void testTTime07() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013, 2)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 2 1 6 32 0 0 0 0 9");
		eot("AD 2013 2 1 6 32 0 0 0 0 9");
	}

	public void testTTime08() {
		AwkExecutable e = pre("" +
				"{ t = t.time(2013)\n" +
				"  a = t.toarray(t)\n" +
				"  print a[\"era\"], a[\"year\"], a[\"month\"], a[\"day\"]," +
				"        a[\"week\"], a[\"dayofyear\"]," +
				"        a[\"hour\"], a[\"min\"], a[\"sec\"]," +
				"        a[\"millisec\"], a[\"zone\"] }");

		e.execute(ns0, fs0, "AD 2013 1 1 3 1 0 0 0 0 9");
		eot("AD 2013 1 1 3 1 0 0 0 0 9");
	}

	public void testTFormat() {
		long t = t("2013/02/01 12:34:56 789");

		eqs("t.format(\"yyyy/MM/dd HH:mm:ss SSS\", " + t + ")",
				"2013/02/01 12:34:56 789");
	}

	public void testTParse() {
		long t = t("2013/02/01 12:34:56 789");

		eqi("t.parse(\"yyyy/MM/dd HH:mm:ss SSS\", " +
				"\"2013/02/01 12:34:56 789\")", t);
		und("t.parse(\"yyyy/MM/dd HH:mm:ss SSS\", \"2013\")");
	}

}
