package net.morilib.sh.misc;

import junit.framework.TestCase;

public class ByteRingBufferTest extends TestCase {

	public void test001() {
		ByteRingBuffer b = new ByteRingBuffer(10);

		assertEquals(b.toString(), "");
		b.add((byte)'1');
		assertEquals(b.toString(), "1");
		b.add((byte)'2');  b.add((byte)'3');
		b.add((byte)'4');  b.add((byte)'5');
		b.add((byte)'6');  b.add((byte)'7');
		b.add((byte)'8');  b.add((byte)'9');
		b.add((byte)'0');
		assertEquals(b.toString(), "1234567890");
		b.add((byte)'1');
		assertEquals(b.toString(), "2345678901");
		b.add((byte)'2');
		b.add((byte)'3');
		assertEquals(b.toString(), "4567890123");
		b.add((byte)'4');  b.add((byte)'5');
		b.add((byte)'6');  b.add((byte)'7');
		b.add((byte)'8');  b.add((byte)'9');
		b.add((byte)'0');
		assertEquals(b.toString(), "1234567890");
		b.add((byte)'1');  b.add((byte)'2');
		b.add((byte)'3');  b.add((byte)'4');
		b.add((byte)'5');  b.add((byte)'6');
		b.add((byte)'7');  b.add((byte)'8');
		b.add((byte)'9');  b.add((byte)'0');
		assertEquals(b.toString(), "1234567890");
	}

	public void test002() {
		ByteRingBuffer b = new ByteRingBuffer(2);

		assertEquals(b.toString(), "");
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.toString(), "12");
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.toString(), "12");
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.toString(), "12");
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.toString(), "12");
		b.add((byte)'1');
		assertEquals(b.toString(), "21");
	}

	public void test003() {
		ByteRingBuffer b = new ByteRingBuffer(4);

		b.add((byte)'1');  b.add((byte)'2');
		b.add((byte)'3');  b.add((byte)'4');
		assertEquals(b.get(0), (byte)'1');
		assertEquals(b.get(1), (byte)'2');
		assertEquals(b.get(2), (byte)'3');
		assertEquals(b.get(3), (byte)'4');
		assertEquals(b.remove(), (byte)'4');
		assertEquals(b.toString(), "123");
		assertFalse(b.isEmpty());
		assertEquals(b.size(), 3);
		assertEquals(b.remove(), (byte)'3');
		assertEquals(b.remove(), (byte)'2');
		assertEquals(b.remove(), (byte)'1');
		assertEquals(b.toString(), "");
		assertTrue(b.isEmpty());
		assertEquals(b.size(), 0);
		b.add((byte)'1');  b.add((byte)'2');
		b.add((byte)'3');  b.add((byte)'4');
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.get(0), (byte)'3');
		assertEquals(b.get(1), (byte)'4');
		assertEquals(b.get(2), (byte)'1');
		assertEquals(b.get(3), (byte)'2');
		assertEquals(b.toString(), "3412");
		assertFalse(b.isEmpty());
		assertEquals(b.size(), 4);
		assertEquals(b.remove(), (byte)'2');
		assertEquals(b.toString(), "341");
		assertEquals(b.size(), 3);
		assertEquals(b.remove(), (byte)'1');
		assertEquals(b.remove(), (byte)'4');
		assertEquals(b.remove(), (byte)'3');
		assertEquals(b.toString(), "");
		assertEquals(b.size(), 0);
		assertTrue(b.isEmpty());
	}

	public void test004() {
		ByteRingBuffer b = new ByteRingBuffer(4);

		b.add((byte)'1');  b.add((byte)'2');
		b.add((byte)'3');  b.add((byte)'4');
		b.add((byte)'1');  b.add((byte)'2');
		b.clear();
		assertEquals(b.toString(), "");
		assertTrue(b.isEmpty());
		b.add((byte)'1');  b.add((byte)'2');
		assertEquals(b.toString(), "12");
	}

	public void test005() {
		ByteRingBuffer b = new ByteRingBuffer(10);

		b.add("12".getBytes());
		assertEquals(b.toString(), "12");
		b.add((byte)'3');  b.add((byte)'4');
		assertEquals(b.toString(), "1234");
	}

	public void test006() {
		ByteRingBuffer b = new ByteRingBuffer(10);

		b.add("12".getBytes());
		assertEquals(b.toString(), "12");
		b.add("3456".getBytes());
		assertEquals(b.toString(), "123456");
		b.add("7890".getBytes());
		assertEquals(b.toString(), "1234567890");
		b.add("12".getBytes());
		assertEquals(b.toString(), "3456789012");
		b.add("3456".getBytes());
		assertEquals(b.toString(), "7890123456");
		b.remove();
		b.add("6".getBytes());
		assertEquals(b.toString(), "7890123456");
		b.remove();
		b.add("67".getBytes());
		assertEquals(b.toString(), "8901234567");
		b.add("8901234567890".getBytes());
		assertEquals(b.toString(), "1234567890");
		b.add("".getBytes());
		assertEquals(b.toString(), "1234567890");
	}

	public void test007() {
		ByteRingBuffer b = new ByteRingBuffer(10);

		b.add("12xx".getBytes(), 2);
		assertEquals(b.toString(), "12");
		b.add("3456xx".getBytes(), 4);
		assertEquals(b.toString(), "123456");
		b.add("7890xx".getBytes(), 4);
		assertEquals(b.toString(), "1234567890");
		b.add("12xx".getBytes(), 2);
		assertEquals(b.toString(), "3456789012");
		b.add("3456xx".getBytes(), 4);
		assertEquals(b.toString(), "7890123456");
		b.remove();
		b.add("6xx".getBytes(), 1);
		assertEquals(b.toString(), "7890123456");
		b.remove();
		b.add("67xx".getBytes(), 2);
		assertEquals(b.toString(), "8901234567");
		b.add("8901234567890xx".getBytes(), 13);
		assertEquals(b.toString(), "1234567890");
		b.add("".getBytes());
		assertEquals(b.toString(), "1234567890");
	}

}
