/**
  * $Id: CookieManager.h,v 1.2 2005-09-30 18:52:03 tsawada2 Exp $
  * 
  * CookieManager.h
  *
  * Copyright (c) 2003-2004 Takanori Ishikawa, All rights reserved.
  * See the file LICENSE for copying permission.
  */
#import <SGFoundation/SGFoundation.h>
#import <CocoMonar/CocoMonar.h>



@interface CookieManager : NSObject<CMRPropertyListCoding>
{
	@private
	NSDictionary		*_cookies;
}
+ (id) defaultManager;

- (NSDictionary *) cookies;
- (void) setCookies : (NSDictionary *) aCookies;

- (void) setCookiesArray : (NSArray  *) aCookiesArray
				 forHost : (NSString *) aHost;
- (void) removeAllCookies;

//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * PA܂͕̃NbL[ݒ܂Ƃ߂@"Set-Cookie"wb_
  * ͂AK؂ȐCookie𐶐AzɊi[ĕԂB
  * 
  * @param    header  wb_
  * @return           Cookie̔z(sɂnil)
  */
- (NSArray *) scanSetCookieHeader : (NSString *) header;

/**
  * @"Set-Cookie"ŗvꂽNbL[ێB
  * 
  * @param    header    @"Set-Cookie"wb_
  * @param    hostName  ṽzXg
  */
- (void) addCookies : (NSString *) header
         fromServer : (NSString *) hostName;

/**
  * MɑׂURLꍇ̓NbL[ԂB
  * 
  * @param    anURL  MURL
  * @param    withBe  Be OCp̃NbL[t邩ǂ
  * @return          NbL[
  */
- (NSString *) cookiesForRequestURL : (NSURL *) anURL
					   withBeCookie : (BOOL   ) withBe;

/**
  * ؂̃NbL[폜B
  */
- (void) deleteExpiredCookies;

/**
  * ؂̃NbL[폜AώŕԂB
  * 
  * @param    dict  
  * @return         ؂̃NbL[폜
  */
- (NSMutableDictionary *) dictionaryByDeletingExpiredCookies : (NSDictionary *) dict;

/**
  * t@CƂĕۑB
  * 
  * @param    path  ۑꏊ̃pX
  * @param    flag  NOȂ璼ځAށB
  * @return         YES
  */
- (BOOL) writeToFile : (NSString *) path
          atomically : (BOOL      ) flag;

- (NSDictionary *) dictionaryRepresentation;
@end
