//:LoginController-VAccessor.m
#import "LoginController_p.h"



@implementation LoginController(ViewAccessor)
- (NSButton *) cancelButton
{
	return m_cancelButton;
}
- (NSButton *) okButton
{
	return m_okButton;
}

- (NSTextField *) passwordField
{
	return m_passwordField;
}
- (NSButton *) shouldSavePWBtn
{
	return m_shouldSavePWBtn;
}

- (NSTextField *) userIDField
{
	return m_userIDField;
}
@end



@implementation LoginController(UISetup)
- (void) updateButtonState
{
	BOOL      canLogin_;
	NSString *value_;
	
	//pX[h͂ĂȂA邢
	//[UID͂ĂȂꍇ
	//OCłȂB
	canLogin_ = NO;
	value_ = [[self userIDField] stringValue];
	canLogin_ = (value_ != nil && [value_ length] > 0);
	value_ = [[self passwordField] stringValue];
	canLogin_ = canLogin_ && (value_ != nil && [value_ length] > 0);
	
	[[self okButton] setEnabled : canLogin_];
}

- (void) setupUIComponents
{
	NSString		*account_;
	NSString		*password_;
	BOOL			hasAccountInKeychain_;
	BOOL			shouldLoginIfNeeded_;
	
	account_ = [[self preferences] x2chUserAccount];
	password_ = nil;
	hasAccountInKeychain_ = [[self preferences] hasAccountInKeychain];
	shouldLoginIfNeeded_ = [[self preferences] shouldLoginIfNeeded];
	
	if(hasAccountInKeychain_){
		password_ = [[self preferences] password];
		if(nil == password_) password_ = @"";
		
		[[self passwordField] setEnabled : YES];
		[[self passwordField] setStringValue : password_];
	}
	
	[[self userIDField] setStringValue : account_ ? account_ : @""];
	[self updateButtonState];
}
@end



@implementation LoginController(NSControlDelegate)
- (void) controlTextDidChange : (NSNotification *) aNotification
{
	UTILAssertNotificationName(
		aNotification,
		NSControlTextDidChangeNotification);
		
	[self updateButtonState];
}

@end
