//:w2chConnect.h
/**
  *
  * 2chɐڑłNX̃vgR
  *
  * @version 1.0.1 (02/02/04  5:44:38 PM)
  *
  */
#import <Foundation/Foundation.h>

@class SGHTTPConnector;

typedef enum {
	kw2chConnectGettingSubject_txtMode,		//subject.txt̎擾
	kw2chConnectGettingDATMode,				//.datt@C̎擾
	kw2chConnectPOSTMessageMode,			//"POST"\bh̎s
	

} w2chConnectMode;

//Error Handling

// Ή\ReplyErrorCode.plistQ
enum {
	k2chNoneErrorType 				= 0,		// 
	k2chEmptyDataErrorType			= 1,		// f[^Ȃ
	k2chAnyErrorType				= 2,		// dqqnqI
	k2chContributionCheckErrorType	= 3,		// emF

	k2chRequireNameErrorType		= 4,		// OĂ
	k2chRequireContentsErrorType	= 5,		// {܂B
	k2chSPIDCookieErrorType			= 6,		// NbL[mFI
	k2chDoubleWritingErrorType		= 7,		// d
	k2chWarningType					= 8,		// ӎ
	
	
	k2chUnknownErrorType
};

typedef struct {
	int type;
	w2chConnectMode mode;
	int error;
} SG2chServerError;

@protocol w2chConnect<NSObject>
- (SGHTTPConnector*) HTTPConnector;
- (id) delegate;

- (void) setDelegate : (id) newDelegate;

/**
  * eRlN^̏Ώۂ\萔ԂB
  * 
  * @return     SG2chConnectorMode
  */
- (w2chConnectMode) mode;

/**
  * ̎_ŎMf[^ԂB
  * kĂꍇ͓WJB
  * 
  * @return     Mf[^
  */
- (NSData *) availableResourceData;

/**
  * V[o̕ێf[^ԂB
  * Kvȏꍇ͐ڑAf[^M
  * 
  * @return     ێf[^
  */
- (NSData *) resourceData;

/**
  * MJnBI܂ŃubNB
  * 
  * @return     Mf[^
  */
- (NSData *) loadInForeground;

/**
  * obNOEhŎMJnB
  */
- (void) loadInBackground;

/**
  * obNOEhł̎M𒆎~B
  */
- (void) cancelLoadInBackground;

/**
  * T[oɑMf[^ݒB
  * ̂ƂA"Content-Length"wb_
  * Iɐݒ肳B
  * 
  * @param    data  Mf[^
  * @return         ɂYES
  */
- (BOOL) writeData : (NSData *) data;

/**
  * T[oɑMtH[̃f[^ݒ肷B
  * ̂ƂA"Content-Length"wb_yсA"Content-Type"
  * wb_͎Iɐݒ肳B
  * 
  * @param    forms  tH[̕ϐƒl[߂IuWFNg
  * @return          ɂYES
  */
- (BOOL) writeForm : (NSDictionary *) forms;


//response
/**
  * T[õX|XԂB
  * 
  * @return     wb_
  */
- (NSDictionary *) responseHeaders;

/**
  * X|Xwb_QƁB
  * 
  * @param    field  tB[h
  * @return          l
  */
- (NSString *) headerFieldValueForKey : (NSString *) field;

/**
  * T[õX|XR[hԂB
  * 
  * @return     X|XR[h
  */
- (unsigned) statusCode;

/**
  * Xe[^XsԂB
  * 
  * @return     Xe[^Xs
  */
- (NSString *) statusLine;

- (NSURL *) requestURL;

- (NSString *) requestMethod;
@end

//Error Handling
@protocol w2chErrorHandling<NSObject>
//////////////////////////////////////////////////////////////////////
////////////////////// [ ANZT\bh ] //////////////////////////
//////////////////////////////////////////////////////////////////////
- (NSURL *) requestURL;
- (w2chConnectMode) requestMode;
- (SG2chServerError) recentError;
- (NSString *) recentErrorTitle;
- (NSString *) recentErrorMessage;
- (void) setRecentErrorCode : (int) code;
//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * T[o[ԂĂf[^󂯂ƂAG[ǂ
  * fBSG2chServerError\̂typek2chNoneErrorType
  * ȊO̓G[B
  * 
  * @param    contents  T[o[ԂĂf[^
  * @param    title     G[̓eȌɕ\
  * @param    message   G[̓e
  * @return             SG2chServerError\
  */
- (SG2chServerError) handleErrorWithContents : (NSString  *) contents
                                       title : (NSString **) title
                                     message : (NSString **) message; 

@end


//Delegate
@interface NSObject(w2chConnectDelegate)
/////////////////////////////////////////////////////////////////////
////////////////// [ M̊JnAIALZȂ ] /////////////
/////////////////////////////////////////////////////////////////////

- (void) connectorResourceDidBeginLoading : (id<w2chConnect>) sender;

- (void) connectorResourceDidCancelLoading : (id<w2chConnect>) sender;

- (void) connectorResourceDidFinishLoading : (id<w2chConnect>) sender;
  
/////////////////////////////////////////////////////////////////////
///////////////////// [ f[^̎M֌W ] //////////////////////////
/////////////////////////////////////////////////////////////////////

- (void) connector               : (id<w2chConnect>) sender
  resourceDataDidBecomeAvailable : (NSData      *) newBytes;

- (void) connector                 : (id<w2chConnect>) sender
  resourceDidFailLoadingWithReason : (NSString    *) reason;

/**
  * MEM͊A炩̗RŎ󂯓ȂB
  * 
  * @param    sender   RlN^[
  * @param    handler  G[IuWFNg
  */
- (void) connector                 : (id<w2chConnect>) sender
   resourceDidFailLoadingWithError : (id<w2chErrorHandling>) handler;
@end


