//:Cookie.m
#import "Cookie.h"



//////////////////////////////////////////////////////////////////////
////////////////////// [ 萔}Nu ] //////////////////////////
//////////////////////////////////////////////////////////////////////
/* NbL[̃IvV */
#define kCookieOptionPath			@"path"
#define kCookieOptionDomain			@"domain"
#define kCookieOptionExpires		@"expires"
#define kCookieOptionSecure			@"secure"
/* p */
#define kCookieOptionEnabled		@"x-application/CocoMonar enabled"



@implementation Cookie
//////////////////////////////////////////////////////////////////////
/////////////////////// [ En ] ///////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * ꎞIuWFNg̐B
  * 
  * @return                 ꎞIuWFNg
  */
+ (id) cookie
{
	return [[[[self class] alloc] init] autorelease];
}

/**
  * ꎞIuWFNg̐B
  * \CX^X𐶐AB
  * 
  * @param      anyCookies  \
  * @return     ꎞIuWFNg
  */
+ (id) cookieWithString : (NSString *) anyCookies
{
	return [[[[self class] alloc] initWithString : anyCookies] autorelease];
}

/**
  * ꎞIuWFNg̐B
  * IuWFNgCX^X𐶐AB
  * 
  * @param      anyCookies  IuWFNg
  * @return                 ꎞIuWFNg
  */
+ (id) cookieWithDictionary : (NSDictionary *) anyCookies
{
	return [[[[self class] alloc] initWithDictionary : anyCookies] autorelease];
}

- (id) init
{
	if(self = [super init]){
		[self setIsEnabled : YES];
	}
	return self;
}

/**
  * wCjVCUB
  * \CX^X𐶐AB
  * 
  * @param    anyCookies  \
  * @return               ς݂̃CX^X
  */
- (id) initWithString : (NSString *) anyCookies
{
	if(self = [self init]){
		[self setCookieWithString : anyCookies];
	}
	return self;
}

/**
  * wCjVCUB
  * IuWFNgCX^X𐶐AB
  * 
  * @param    anyCookies  IuWFNg
  * @return               ς݂̃CX^X
  */
- (id) initWithDictionary : (NSDictionary *) dict
{
	
	if(self = [self init]){
		if(nil == dict)
			return self;
		
		[self setCookieWithDictionary : dict];
	}
	return self;
}

- (void) dealloc
{
	[m_name release];		//O
	[m_value release];		//l
	[m_path release];		//NbL[LłURL͈
	[m_domain release];		//NbL[LłhC͈
	[m_expires release];	//L
	[super dealloc];
}

//////////////////////////////////////////////////////////////////////
////////////////////// [ ANZT\bh ] //////////////////////////
//////////////////////////////////////////////////////////////////////
/* Accessor for m_name */
- (NSString *) name
{
	return m_name;
}
- (void) setName : (NSString *) aName
{
	[aName retain];
	[[self name] release];
	m_name = aName;
}
/* Accessor for m_value */
- (NSString *) value
{
	return m_value;
}
- (void) setValue : (NSString *) aValue
{
	[aValue retain];
	[[self value] release];
	m_value = aValue;
}
/* Accessor for m_path */
- (NSString *) path
{
	return m_path;
}

- (void) setPath : (NSString *) aPath
{
	[aPath retain];
	[[self path] release];
	m_path = aPath;
}
/* Accessor for m_domain */
- (NSString *) domain
{
	return m_domain;
}
- (void) setDomain : (NSString *) aDomain
{
	[aDomain retain];
	[[self domain] release];
	m_domain = aDomain;
}
/* Accessor for m_expires */
- (NSString *) expires
{
	return m_expires;
}
- (void) setExpires : (NSString *) anExpires
{
	[anExpires retain];
	[[self expires] release];
	m_expires = anExpires;
}
/* Accessor for m_secure */
- (BOOL) secure
{
	return m_secure;
}
- (void) setSecure : (BOOL) aSecure
{
	m_secure = aSecure;
}
/* Accessor for m_isEnabled */
- (BOOL) isEnabled
{
	return m_isEnabled;
}
- (void) setIsEnabled : (BOOL) anIsEnabled
{
	m_isEnabled = anIsEnabled;
}
//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * V[õNbL[LURLȂYESԂB
  * 
  * @param    anURL  ΏURL
  * @return          NbL[LURLȂYES
  */
- (BOOL) isAvalilableURL : (NSURL *) anURL
{
	if(nil == anURL) return NO;
	
	//pathw肳Ă΁A}b`邩
	if(nil == [self path]) return YES;
	return [[anURL path] hasPrefix : [self path]];
}

/**
  * ؂̏ꍇYESԂB
  * IɔjꍇɂwhenTerminate = YES
  *
  * @param   whenTerminate   IɔjꍇYES
  * @return                  ؂̏ꍇYES
  */
- (BOOL) isExpired : (BOOL *) whenTerminate
{
	NSDate *exp_;
	
	exp_ = [self expiresDate];
	if(nil == exp_){
		//Iɔj
		if(whenTerminate != NULL) *whenTerminate = YES;
		return NO;
	}
	return [exp_ isBeforeDate : [NSDate date]];
}


/**
  * V[ô`ŕԂB
  * 
  * @return     IuWFNg
  */
- (NSDictionary *) dictionaryRepresentation
{
	NSMutableDictionary *dict_;
	
	dict_ = [NSMutableDictionary dictionary];
	//IvVۑ
	if([self path] != nil){
		[dict_ setObject : [self path]
				  forKey : kCookieOptionPath];
	}
	if([self domain] != nil){
		[dict_ setObject : [self domain]
				  forKey : kCookieOptionDomain];
	}
	if([self expires] != nil){
		[dict_ setObject : [self expires]
				  forKey : kCookieOptionExpires];
	}
	[dict_ setBool : [self secure]
		    forKey : kCookieOptionSecure];
	[dict_ setBool : [self isEnabled]
		    forKey : kCookieOptionEnabled];
	//NbL[ۑ
	if([self name] != nil && [self value] != nil){
		[dict_ setObject : [self value]
			      forKey : [self name]];
	}
	return dict_;
}


//:ANZT
/**
  * LԂB
  * 
  * @return     L
  */
- (NSDate *) expiresDate
{
	if(nil == [self expires]) return nil;
	return [NSCalendarDate dateWithHTTPTimeRepresentation : [self expires]];
}

//NbL[̐ݒ
/**
  * NbL[ݒB
  * 
  * @param    aValue  l
  * @param    aName   O
  */
- (void) setCookie : (id        ) aValue
           forName : (NSString *) aName
{
	if(nil == aValue || nil == aName) return;
	//IvVw̏ꍇ̓CX^Xϐɕێ
	if([aName isEqualToString : kCookieOptionSecure]){
		if(NO == [aValue respondsToSelector : @selector(boolValue)])
			[self setSecure : NO];
		[self setSecure : [aValue boolValue]];
	}else if([aName isEqualToString : kCookieOptionEnabled]){
		if(NO == [aValue respondsToSelector : @selector(boolValue)])
			[self setIsEnabled : YES];
		[self setIsEnabled : [aValue boolValue]];
	}else if([aName isEqualToString : kCookieOptionPath]){
		[self setPath : aValue];
	}else if([aName isEqualToString : kCookieOptionDomain]){
		[self setDomain : aValue];
	}else if([aName isEqualToString : kCookieOptionExpires]){
		[self setExpires : aValue];
	}else{
		[self setName : aName];
		[self setValue : aValue];
	}
}

/**
  * 񂩂ϊB
  * IvVw肵ꍇ́AfB
  * 
  * ex : @"SPID=XWDtLhNY; expires=1016920836 GMT; path=/"
  * 
  * @param    anyCookies  \
  */
- (void) setCookieWithString : (NSString *) anyCookies
{
	NSArray      *comps_;		//gzIuWFNg
	NSEnumerator *iter_;		//
	NSString     *item_;		//eg
	
/*	SGDebug;
*/	if(nil == anyCookies) return;
/*	UTILDebugLog(@"anyCookies = %@", anyCookies);
*/	comps_ = [anyCookies componentsSeparatedByString : @";"];
	if(nil == comps_ || 0 == [comps_ count]) return;
/*	UTILDebugLog(@"comps_ = (%d)", [comps_ count]);
*/	iter_ = [comps_ objectEnumerator];
	while(item_ = [iter_ nextObject]){
		NSArray         *pair_;				//OAl
		NSMutableString *name_, *value_;
		
/*		UTILDebugLog(@"item_ = %@", item_);
*/		pair_ = [item_ componentsSeparatedByString : @"="];
		if(nil == pair_) continue;
		
		//Secure
		if(1 == [pair_ count]){
			NSMutableString *cstr_;
			
			cstr_ = [NSMutableString stringWithString : [pair_ objectAtIndex : 0]];
			[cstr_ strip];
			
			if([cstr_ isEqualToString : kCookieOptionSecure])
				[self setSecure : YES];
			continue;
		}
		if([pair_ count] != 2) continue;
		
		name_ = [NSMutableString stringWithString : [pair_ objectAtIndex : 0]];
		value_ = [NSMutableString stringWithString : [pair_ objectAtIndex : 1]];
		//擪A̋󔒂폜
		[name_ strip];
		[value_ strip];
/*		UTILDebugLog(@"name = %@", name_);
*/		[self setCookie : value_
		        forName : name_];
	}
}

/**
  * IuWFNgϊB
  * IvVw肵ꍇ́AfB
  * 
  * 
  * @param    anyCookies  IuWFNg
  */
- (void) setCookieWithDictionary : (NSDictionary *) anyCookies
{
	NSEnumerator    *iter_;		//L[
	NSString        *key_;		//L[
	
	if(nil == anyCookies) return;
	
	iter_ = [anyCookies keyEnumerator];
	while(key_ = [iter_ nextObject]){
		id value_;
		
		value_ = [anyCookies objectForKey : key_];
		if(nil == value_) continue;
		
		[self setCookie : value_
			    forName : key_];
	}
}

/**
  * NbL[𕶎ŕ\̂ԂB
  * 
  * @return     \
  */
- (NSString *) stringValue
{
	if(nil == [self name] || nil == [self value])
		return nil;
	return [NSString stringWithFormat : @"%@=%@",
										[self name],
										[self value]];
}

/////////////////////////////////////////////////////////////////////
/////////////////////////// NSObject ////////////////////////////////
/////////////////////////////////////////////////////////////////////
- (NSString *) description
{
	return [self stringValue];
}

- (BOOL) isEqual : (id) obj
{
	if([super isEqual : obj])
		return YES;
	if(NO == [obj isKindOfClass : [self class]])
		return NO;
	if(NO == [[obj name] isEqualToString : [self name]])
		return NO;
	if(NO == [[obj path] isEqualToString : [self path]])
		return NO;
	return YES;
}
/////////////////////////////////////////////////////////////////////
////////////////////////// NSCopying ////////////////////////////////
/////////////////////////////////////////////////////////////////////
- (id) copyWithZone : (NSZone *) zone
{
	Cookie		*tmpcopy;
	
	tmpcopy = [[[self class] allocWithZone : zone] init];
	[tmpcopy setName : [self name]];
	[tmpcopy setValue : [self value]];
	[tmpcopy setPath : [self path]];
	[tmpcopy setDomain : [self domain]];
	[tmpcopy setExpires : [self expires]];
	[tmpcopy setSecure : [self secure]];
	[tmpcopy setIsEnabled : [self isEnabled]];
	
	return tmpcopy;
}
@end
