//
//  String+Utils.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 09/06/15.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Foundation/Foundation.h>


@interface NSObject(SGStringUtils)
- (NSString *)stringValue;
@end


@interface NSString(SGStringUtils)
+ (NSString *)yenmark;
+ (NSString *)backslash;

- (BOOL)isEmpty;
- (NSRange)range;

- (BOOL)boolValue; // NOTE: Mac OS X v10.5 以降では -[NSString boolValue] が元々存在するぞ！注意。
- (NSString *)stringValue;
- (unsigned)hexIntValue;
- (unsigned)unsignedIntValue;
@end


@interface NSAttributedString(SGStringUtils)
- (BOOL)isEmpty;
- (NSRange)range;
- (NSString *)stringValue;
@end


@interface NSData(SGNetEncoding)
- (NSString *)stringByUsingURLEncoding;
- (NSString *)stringByUsingURLEncodingUsingEncoding:(NSStringEncoding)encoding; // Available in BathyScaphe 1.6.3 "Hinagiku" and later.
@end


@interface NSString(SGNetEncoding)
- (NSString *)stringByURLEncodingUsingEncoding:(NSStringEncoding)encoding;
// Available in BathyScaphe 1.6.4 "Stealth Momo" and later.
- (NSString *)stringByURLEncodingUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag unableToEncode:(NSIndexSet **)indexes;
// 変換できない文字を文字参照に置き換える
- (NSData *)dataUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag; // Available in BathyScaphe 1.6.3 "Hinagiku" and later.
// Available in BathyScaphe 1.6.4 "Stealth Momo" and later.
// 変換できなかった文字のインデックスも返す
- (NSData *)dataUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag unableToEncode:(NSIndexSet **)indexes;
// V2C に習った対策
// http://v2c.s50.xrea.com/manual/write.html の最下部の表参照
- (NSString *)stringByReplacingSomeCharactersLikeV2C; // Available in BathyScaphe 1.6.3 "Hinagiku" and later.
@end
