//
//  CMRFavoritesManager.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 07/12/09.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>

@class CMRThreadSignature;

enum {
	CMRFavoritesOperationNone,
	CMRFavoritesOperationLink,
	CMRFavoritesOperationRemove
};
typedef unsigned int CMRFavoritesOperation;


@interface CMRFavoritesManager : NSObject
{
}
+ (id)defaultManager;

- (CMRFavoritesOperation)availableOperationWithPath:(NSString *)filepath;
- (CMRFavoritesOperation)availableOperationWithSignature:(CMRThreadSignature *)signature;

- (BOOL)canCreateFavoriteLinkFromPath:(NSString *)filepath;
- (BOOL)favoriteItemExistsOfThreadPath:(NSString *)filepath;
- (BOOL)favoriteItemExistsOfThreadSignature:(CMRThreadSignature *)signature;

- (BOOL)addFavoriteWithSignature:(CMRThreadSignature *)signature;
- (BOOL)removeFromFavoritesWithSignature:(CMRThreadSignature *)signature;
@end

extern NSString *const CMRFavoritesManagerDidLinkFavoritesNotification;
extern NSString *const CMRFavoritesManagerDidRemoveFavoritesNotification;
