//
//  LabelsPrefController.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 10/08/15.
//  Copyright 2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "LabelsPrefController.h"
#import "PreferencePanes_Prefix.h"
#import "BSLabelManager.h"

#define kLabelKey   @"Labels Label"
#define kToolTipKey @"Labels ToolTip"
#define kImageName  @"LabelsPreferences"


@implementation LabelsPrefController
- (NSString *)mainNibName
{
    return @"LabelsPreferences";
}

- (void)updateUIComponents
{
    NSArray *array = [(BSLabelManager *)[NSClassFromString(@"BSLabelManager") defaultManager] displayNames];

    NSInteger i;
    for (i = 0; i < 7; i++) {
        [[labelNamesForm cellAtIndex:i] setStringValue:[array objectAtIndex:i]];
    }
}

- (void)setupUIComponents
{
    if (!_contentView) {
        return;
    }
    [self updateUIComponents];
}

- (void)willUnselect
{
    [super willUnselect];
    NSMutableArray *newArray = [NSMutableArray arrayWithCapacity:7];
    BSLabelManager *manager = (BSLabelManager *)[NSClassFromString(@"BSLabelManager") defaultManager];
    NSInteger i;
    NSString *name;
    for (i = 0; i < 7; i++) {
        name = [[labelNamesForm cellAtIndex:i] stringValue];
        if (!name || [name length] == 0) {
            name = [[manager displayNames] objectAtIndex:i];
        }
        [newArray addObject:name];
    }
    [manager setDisplayNames:newArray];
    [manager saveToFile];
}
@end


@implementation LabelsPrefController(Toolbar)
- (NSString *)identifier
{
    return PPLabelsPreferencesIdentifier;
}

- (NSString *)helpKeyword
{
    return PPLocalizedString(@"Help_Labels");
}

- (NSString *)label
{
    return PPLocalizedString(kLabelKey);
}

- (NSString *)paletteLabel
{
    return PPLocalizedString(kLabelKey);
}

- (NSString *)toolTip
{
    return PPLocalizedString(kToolTipKey);
}

- (NSString *)imageName
{
    return kImageName;
}
@end
