#include "StdAfx.h"
#include "JobErrorDetailsPage.h"
#include "MiscUtil.h"
#include "BITSUtil.h"
#include "WTLCtrlUtil.h"


CJobErrorDetailsPage::CJobErrorDetailsPage(void)
{
	NULL;
}


CJobErrorDetailsPage::~CJobErrorDetailsPage(void)
{
	NULL;
}


LRESULT CJobErrorDetailsPage::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLASSERT(m_spJob);

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(RefreshUI());
	ATLVERIFY(SetTimer(REFRESH_TIMER_ID, REFRESH_INTERVAL));

	return TRUE;
}


LRESULT CJobErrorDetailsPage::OnDestroy(void)
{
	ATLVERIFY(KillTimer(REFRESH_TIMER_ID));

	return 0;
}


LRESULT CJobErrorDetailsPage::OnTimer(__in UINT_PTR nIDEvent)
{
	switch (nIDEvent) {
		case REFRESH_TIMER_ID:
			if (FALSE != IsWindowVisible()) {
				ATLVERIFY(RefreshUI());
			}
			break;

		default:
			break;
	}

	return 0;
}


void CJobErrorDetailsPage::EmptyAllErrorStrings(void)
{
	m_strErrorContext.Empty();
	m_strErrorContextDescription.Empty();
	m_strErrorCode.Empty();
	m_strErrorDescription.Empty();
	m_strProtocol.Empty();
	m_strLocalFileName.Empty();
	m_strRemoteFileName.Empty();
}


bool CJobErrorDetailsPage::ShowNoErrorMessage(void)
{
	EmptyAllErrorStrings();

	ShowAllErrorStaticControls(SW_HIDE);
	m_editNoErrorOccurMsg.ShowWindow(SW_SHOW);

	ATLVERIFY(UpdateErrorMessage());

	return true;
}


bool CJobErrorDetailsPage::ShowAllErrorStaticControls(__in int nCmdShow)
{
	if (SW_HIDE != nCmdShow && SW_SHOW != nCmdShow) {
		ATLASSERT(false);
		return false;
	}

	m_staticErrorContextTitle.ShowWindow(nCmdShow);
	m_staticErrorContextDescriptionTitle.ShowWindow(nCmdShow);
	m_staticErrorCodeTitle.ShowWindow(nCmdShow);
	m_staticErrorDescriptionTitle.ShowWindow(nCmdShow);
	m_staticProtocolTitle.ShowWindow(nCmdShow);
	m_staticLocalFileNameTitle.ShowWindow(nCmdShow);
	m_staticRemoteFileNameTitle.ShowWindow(nCmdShow);
	m_editErrorContext.ShowWindow(nCmdShow);
	m_editErrorContextDescription.ShowWindow(nCmdShow);
	m_editErrorCode.ShowWindow(nCmdShow);
	m_editErrorDescription.ShowWindow(nCmdShow);
	m_editProtocol.ShowWindow(nCmdShow);
	m_editLocalFileName.ShowWindow(nCmdShow);
	m_editRemoteFileName.ShowWindow(nCmdShow);

	return true;
}


bool CJobErrorDetailsPage::UpdateErrorMessage(void)
{
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editErrorContext, m_strErrorContext));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editErrorContextDescription, m_strErrorContextDescription));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editErrorCode, m_strErrorCode));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editErrorDescription, m_strErrorDescription));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editProtocol, m_strProtocol));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editLocalFileName, m_strLocalFileName));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editRemoteFileName, m_strRemoteFileName));

	return true;
}


bool CJobErrorDetailsPage::RefreshUI(void)
{
	CComPtr<IBackgroundCopyError> spError;
	HRESULT hr = m_spJob->GetError(&spError);
	if (FAILED(hr)) {
		ATLASSERT(BG_E_ERROR_INFORMATION_UNAVAILABLE == hr);
		ShowNoErrorMessage();
		return true; 
	}

	EmptyAllErrorStrings();
	
	if (!spError) {
		ATLASSERT(false);
		ATLVERIFY(DoDataExchange(FALSE));
		return false;
	}

	BG_ERROR_CONTEXT errorContext = BG_ERROR_CONTEXT_UNKNOWN;
	HRESULT hrError = E_UNEXPECTED;
	hr = spError->GetError(&errorContext, &hrError);
	if (SUCCEEDED(hr)) {
		BOOL bResult = m_strErrorContext.LoadString(IDS_STATUS_BG_ERROR_CONTEXT_NONE + errorContext);
		ATLASSERT(bResult);
		UNREFERENCED_PARAMETER(bResult);

		m_strErrorCode.Format(L"0x%08x", hrError);
	} else {
		ATLASSERT(false);
	}

	hr = BITSUtil::GetJobErrorContextDescription(spError, &m_strErrorContextDescription);
	ATLASSERT(SUCCEEDED(hr));

	hr = BITSUtil::GetJobErrorDescription(spError, &m_strErrorDescription);
	ATLASSERT(SUCCEEDED(hr));

	hr = BITSUtil::GetJobErrorProtocol(spError, &m_strProtocol);
	ATLASSERT(SUCCEEDED(hr));

	CComPtr<IBackgroundCopyFile> spErrorFile;
	hr = BITSUtil::GetJobErrorFile(spError, reinterpret_cast<CComPtr<IBackgroundCopyFile>*>(&spErrorFile));
	ATLASSERT(SUCCEEDED(hr));
	
	if (spErrorFile) {
		hr = BITSUtil::GetJobLocalFileName(spErrorFile, &m_strLocalFileName);
		ATLASSERT(SUCCEEDED(hr));

		hr = BITSUtil::GetJobRemotelFileName(spErrorFile, &m_strRemoteFileName);
		ATLASSERT(SUCCEEDED(hr));
	}

	m_editNoErrorOccurMsg.ShowWindow(SW_HIDE);
	ShowAllErrorStaticControls(SW_SHOW);

	ATLVERIFY(UpdateErrorMessage());

	return true;
}


void CJobErrorDetailsPage::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobErrorDetailsPage::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);

	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob = spJob;

	return;
}
