#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobErrorDetailsPage: public CPropertyPageImpl<CJobErrorDetailsPage>,
	public CWinDataExchange<CJobErrorDetailsPage>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_ERROR_DETAIL };

	BEGIN_DDX_MAP(CJobErrorDetailsPage)
		DDX_CONTROL_HANDLE(IDC_EDIT_ERROR_CONTEXT,					m_editErrorContext)
		DDX_CONTROL_HANDLE(IDC_EDIT_ERROR_CONTEXT_DESC,				m_editErrorContextDescription)
		DDX_CONTROL_HANDLE(IDC_EDIT_ERROR_CODE,						m_editErrorCode)
		DDX_CONTROL_HANDLE(IDC_EDIT_ERROR_DESC,						m_editErrorDescription)
		DDX_CONTROL_HANDLE(IDC_EDIT_PROTOCOL,						m_editProtocol)
		DDX_CONTROL_HANDLE(IDC_EDIT_LOCAL_FILE_NAME,				m_editLocalFileName)
		DDX_CONTROL_HANDLE(IDC_EDIT_REMOTE_FILE_NAME,				m_editRemoteFileName)
		DDX_CONTROL_HANDLE(IDC_STATIC_NO_ERROR,						m_editNoErrorOccurMsg)
		DDX_CONTROL_HANDLE(IDC_STATIC_ERROR_CONTEXT_TITLE,			m_staticErrorContextTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_ERROR_CONTEXT_DESC_TITLE,		m_staticErrorContextDescriptionTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_ERROR_CODE_TITLE,				m_staticErrorCodeTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_ERROR_DESC_TITLE,				m_staticErrorDescriptionTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_PROTOCOL_TITLE,				m_staticProtocolTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_LOCAL_FILE_NAME_TITLE,		m_staticLocalFileNameTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_REMOTE_FILE_NAME_TITLE,		m_staticRemoteFileNameTitle)
		DDX_CONTROL_HANDLE(IDC_STATIC_NO_ERROR,						m_staticNoErrorOccurMsgTitle)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobErrorDetailsPage)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_TIMER(OnTimer)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobErrorDetailsPage>)
	END_MSG_MAP()

	static const DWORD REFRESH_TIMER_ID	= 128;	
	static const DWORD REFRESH_INTERVAL	= 1 * 1000;

	CJobErrorDetailsPage(void);
	~CJobErrorDetailsPage(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

private:
	CString m_strErrorContext;
	CString m_strErrorContextDescription;
	CString m_strErrorCode;
	CString m_strErrorDescription;
	CString m_strProtocol;
	CString m_strLocalFileName;
	CString m_strRemoteFileName;
	CEdit	m_editErrorContext;
	CEdit	m_editErrorContextDescription;
	CEdit	m_editErrorCode;
	CEdit	m_editErrorDescription;
	CEdit	m_editProtocol;
	CEdit	m_editLocalFileName;
	CEdit	m_editRemoteFileName;
	CEdit	m_editNoErrorOccurMsg;
	CStatic m_staticErrorContextTitle;
	CStatic m_staticErrorContextDescriptionTitle;
	CStatic m_staticErrorCodeTitle;
	CStatic m_staticErrorDescriptionTitle;
	CStatic m_staticProtocolTitle;
	CStatic m_staticLocalFileNameTitle;
	CStatic m_staticRemoteFileNameTitle;
	CStatic m_staticNoErrorOccurMsgTitle;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnDestroy(void);
	LRESULT OnTimer(__in UINT_PTR nIDEvent);

	bool ShowAllErrorStaticControls(__in int nCmdShow);
	bool ShowNoErrorMessage(void);
	bool UpdateErrorMessage(void);

	void EmptyAllErrorStrings(void);
	bool RefreshUI(void);
};
