#include "StdAfx.h"
#include "JobRetryDelaySettingDlg.h"
#include "MiscUtil.h"
#include "BITSUtil.h"


CJobRetryDelaySettingDlg::CJobRetryDelaySettingDlg(void)
{
	NULL;
}


CJobRetryDelaySettingDlg::~CJobRetryDelaySettingDlg(void)
{
	NULL;
}


LRESULT CJobRetryDelaySettingDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLASSERT(m_spJob);

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());
	ATLVERIFY(CenterWindow(GetParent()));

	return TRUE;
}


LRESULT CJobRetryDelaySettingDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	BOOL bSuccess = FALSE;
	UINT ulRetryDelayTime = GetDlgItemInt(IDC_EDIT_RETRY_DELAY, &bSuccess, FALSE);
	if (FALSE == bSuccess) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_RETRY_DELAY_VALUE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	if (ulRetryDelayTime < BITSUtil::MINIMUM_RETRY_DELAY) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_TOO_SHORT_RETRY_DELAY_VALUE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	HRESULT hr = BITSUtil::SetJobMinimumRetryDelay(m_spJob, ulRetryDelayTime);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	EndDialog(nID);

	return 0;
}


LRESULT CJobRetryDelaySettingDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	EndDialog(nID);

	return 0;
}


LRESULT CJobRetryDelaySettingDlg::OnEnChangeRetryDelay(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CString strRetryDelay;
	m_editRetryDelay.GetWindowText(strRetryDelay);

	if (true == strRetryDelay.IsEmpty()) {
		m_buttonOK.EnableWindow(FALSE);
	} else {
		m_buttonOK.EnableWindow(TRUE);
	}

	return 0;
}


bool CJobRetryDelaySettingDlg::InitDialogControls(void)
{
	ULONG ulRetryDelay = BITSUtil::DEFAULT_RETRY_DELAY;
	HRESULT hr = BITSUtil::GetJobMinimumRetryDelay(m_spJob, &ulRetryDelay);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	CString strRetryDelay;
	strRetryDelay.Format(L"%u", ulRetryDelay);

	m_editRetryDelay.SetWindowText(strRetryDelay);
	ATLVERIFY(MiscUtil::SetUINTMaxTextLimit(&m_editRetryDelay));

	return true;
}


void CJobRetryDelaySettingDlg::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobRetryDelaySettingDlg::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);

	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob = spJob;

	return;
}
