#include "StdAfx.h"
#include "resource.h"
#include "MiscUtil.h"

int MiscUtil::ShowMessageBox(__in_opt HWND hWnd, __in LPCWSTR lpszText, __in_opt LPCWSTR lpszCaption, __in UINT uType)
{
	if (NULL == lpszText) {
		ATLASSERT(false);
		return 0;
	}

	CString strCaption;
	if (NULL == lpszCaption) {
		BOOL bResult = strCaption.LoadString(IDR_MAINFRAME);
		UNREFERENCED_PARAMETER(bResult);
	} else {
		strCaption = lpszCaption;
	}

	return ::MessageBox(hWnd, lpszText, strCaption, uType);
}


int MiscUtil::ShowMessageBox(__in_opt HWND hWnd, __in UINT uTextId, __in UINT uCaptionId, __in UINT uType)
{
	CString strText;
	CString strCaption;
	BOOL bResult = strText.LoadString(uTextId);
	bResult = strCaption.LoadString(uCaptionId);

	return ::MessageBox(hWnd, strText, strCaption, uType);
}


CString MiscUtil::FormatNumber(__in UINT64 uNumber)
{
	CString strNumberToFormat;
	strNumberToFormat.Format(L"%I64u", uNumber);

	NUMBERFMT format		= {0};
	format.LeadingZero		= 1;
	format.Grouping			= 3;
	format.lpThousandSep	= L",";
	format.lpDecimalSep		= L",";
	format.NegativeOrder	= 1;
	WCHAR szFormatted[255]	= {0};
	int nResult = ::GetNumberFormat(LOCALE_USER_DEFAULT, 0, strNumberToFormat, &format, szFormatted,
		_countof(szFormatted) - sizeof(WCHAR));
	if (0 == nResult) {
		ATLASSERT(false);
		return L" ";
	}

	return szFormatted;
}


CString MiscUtil::GetAccountNameFromSid(__in LPCWSTR lpszSid)
{
	if (NULL == lpszSid) {
		ATLASSERT(false);
		return L"";
	}

	PSID psid = NULL;
	if (0 == ::ConvertStringSidToSid(lpszSid, &psid)) {
		ATLASSERT(false);
		return L"";
	}
	if (NULL == psid) {
		ATLASSERT(false);
		return L"";
	}

	CSid sid(static_cast<const SID*>(psid), NULL);
	::LocalFree(psid);
	psid = NULL;
	
	CString strAccountName;
	strAccountName.Format(L"%s", sid.AccountName());
	ATLASSERT(!strAccountName.IsEmpty());

	return strAccountName;
}


CString MiscUtil::GetJobTypeString(__in BG_JOB_TYPE jobType)
{
	CString strJobType;
	BOOL bResult = FALSE;
	switch (jobType) {
		case BG_JOB_TYPE_DOWNLOAD:
			bResult = strJobType.LoadString(IDS_JOB_TYPE_DOWNLOAD);
			break;

		case BG_JOB_TYPE_UPLOAD:
			bResult = strJobType.LoadString(IDS_JOB_TYPE_UPLOAD);
			break;

		case BG_JOB_TYPE_UPLOAD_REPLY:
			bResult = strJobType.LoadString(IDS_JOB_TYPE_UPLOAD_REPLY);
			break;

		default:
			ATLASSERT(false);
			break;
	}

	ATLVERIFY(bResult);
	return strJobType;
}


CString MiscUtil::GetJobPriorityString(__in BG_JOB_PRIORITY jobPriority)
{

	CString strJobPriority;
	BOOL bResult = FALSE;
	switch (jobPriority) {
		case BG_JOB_PRIORITY_FOREGROUND:
			bResult = strJobPriority.LoadString(IDS_JOB_PRIORITY_FOREGROUND);
			break;

		case BG_JOB_PRIORITY_HIGH:
			bResult = strJobPriority.LoadString(IDS_JOB_PRIORITY_HIGH);
			break;

		case BG_JOB_PRIORITY_NORMAL:
			bResult = strJobPriority.LoadString(IDS_JOB_PRIORITY_NORMAL);
			break;

		case BG_JOB_PRIORITY_LOW:
			bResult = strJobPriority.LoadString(IDS_JOB_PRIORITY_LOW);
			break;

		default:
			ATLASSERT(false);
			break;
	}

	ATLVERIFY(bResult);
	return strJobPriority;
}


CString MiscUtil::GetJobStateString(__in BG_JOB_STATE jobState)
{
	CString strJobState;
	BOOL bResult = FALSE;

	switch (jobState) {
		case BG_JOB_STATE_QUEUED:
			bResult = strJobState.LoadString(IDS_JOB_STATE_QUEUED);
			break;

		case BG_JOB_STATE_CONNECTING:
			bResult = strJobState.LoadString(IDS_JOB_STATE_CONNECTING);
			break;

		case BG_JOB_STATE_TRANSFERRING:
			bResult = strJobState.LoadString(IDS_JOB_STATE_TRANSFERRING);
			break;

		case BG_JOB_STATE_SUSPENDED:
			bResult = strJobState.LoadString(IDS_JOB_STATE_SUSPENDED);
			break;

		case BG_JOB_STATE_ERROR:
			bResult = strJobState.LoadString(IDS_JOB_STATE_ERROR);
			break;

		case BG_JOB_STATE_TRANSIENT_ERROR:
			bResult = strJobState.LoadString(IDS_JOB_STATE_TRANSIENT_ERROR);
			break;

		case BG_JOB_STATE_TRANSFERRED:
			bResult = strJobState.LoadString(IDS_JOB_STATE_TRANSFERRED);
			break;

		case BG_JOB_STATE_ACKNOWLEDGED:
			bResult = strJobState.LoadString(IDS_JOB_STATE_ACKNOWLEDGED);
			break;

		case BG_JOB_STATE_CANCELLED:
			bResult = strJobState.LoadString(IDS_JOB_STATE_CANCELLED);
			break;

		default:
			ATLASSERT(false);
			break;
	}
	
	ATLVERIFY(bResult);
	return strJobState;
}


CString MiscUtil::GetTimeString(__in FILETIME fileTime)
{
	if (0 == fileTime.dwHighDateTime && 0 == fileTime.dwLowDateTime) {
		CString strNA;
		BOOL bResult = strNA.LoadString(IDS_NOT_APPLICABLE);
		ATLVERIFY(bResult);
		return strNA;
	}

	CTime time(fileTime);
	return time.Format(L"%Y/%m/%d %H:%M:%S");
}


CString MiscUtil::LoadEOFString(void)
{
	CString strEOF;
	BOOL bResult = strEOF.LoadString(IDS_EOF);
	ATLASSERT(bResult);UNREFERENCED_PARAMETER(bResult);

	return strEOF;
}


bool MiscUtil::SetUINTMaxTextLimit(__in CEdit* pEdit)
{
	if (NULL == pEdit) {
		ATLASSERT(false);
		return false;
	}

	CString strUINTMax;
	strUINTMax.Format(L"%u", UINT_MAX);
	pEdit->SetLimitText(strUINTMax.GetLength());
	
	return true;
}


bool MiscUtil::GetCurrentProcessUserSid(__in CSid* pSid)
{
	if (NULL == pSid) {
		ATLASSERT(false);
		return false;
	}

	CAccessToken accessToken;
	if (false == accessToken.GetProcessToken(TOKEN_READ)) {
		ATLASSERT(false);
		return false;
	}

	if (false == accessToken.GetOwner(pSid)) {
		ATLASSERT(false);
		return false;
	}

	return true;
}


__checkReturn bool MiscUtil::ConvertStringSidToCSid(__in LPCWSTR lpszSid, __out CSid* psid)
{
	if (NULL == lpszSid) {
		ATLASSERT(false);
		return false;
	}

	PSID pRawSid = NULL;
	if (0 == ::ConvertStringSidToSid(lpszSid, &pRawSid)) {
		ATLASSERT(false);
		return false;
	}
	if (NULL == pRawSid) {
		ATLASSERT(false);
		return false;
	}

	bool bResult = psid->LoadAccount(static_cast<const SID*>(pRawSid), NULL);
	::LocalFree(pRawSid);
	pRawSid = NULL;

	return bResult;
}


__checkReturn CString MiscUtil::GetIntegrityLevelString(__in ULONG lLevel)
{
	CString strLevel;
	BOOL bResult = FALSE;
	if (SECURITY_MANDATORY_UNTRUSTED_RID == lLevel) {
		 bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_UNTRUSTED_RID);
	} else if (SECURITY_MANDATORY_LOW_RID == lLevel) {
		bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_LOW_RID);
	} else if (SECURITY_MANDATORY_MEDIUM_RID == lLevel) { 
		bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_MEDIUM_RID);
	} else if (SECURITY_MANDATORY_HIGH_RID  == lLevel) {
		bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_HIGH_RID);
	} else if (SECURITY_MANDATORY_SYSTEM_RID == lLevel) {
		bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_SYSTEM_RID);
	} else if (SECURITY_MANDATORY_PROTECTED_PROCESS_RID == lLevel) {
		bResult = strLevel.LoadString(IDS_SECURITY_MANDATORY_PROTECTED_PROCESS_RID);
 	} else {
		ATLASSERT(false);
	}
	ATLASSERT(bResult);
	UNREFERENCED_PARAMETER(bResult);

	return strLevel;
}


__checkReturn CString MiscUtil::GetElevationStateString(__in BOOL bElevated)
{
	CString strElevationState;
	BOOL bResult = FALSE;

	if (FALSE == bElevated) {
		bResult = strElevationState.LoadString(IDS_NONE_ELEVATION_STATE);
	} else {
		bResult = strElevationState.LoadString(IDS_ELEVATION_STATE);
	}
	ATLASSERT(bResult);
	UNREFERENCED_PARAMETER(bResult);

	return strElevationState;
}


__checkReturn bool MiscUtil::ConvertSHA1HashByteFromString(__in LPCWSTR lpszHashString, __out_ecount(20) PBYTE pByteData)
{
	if (NULL == lpszHashString || NULL == pByteData) {
		ATLASSERT(false);
		return false;
	}

	CString strHashString = lpszHashString;
	if (40 != strHashString.GetLength()) {
		return false;
	}

	strHashString.MakeLower();

	CString strIncluding = strHashString.SpanIncluding(L"0123456789abcdef");
	if (strIncluding != strHashString) {
		return false;
	}

	int nByteDataIndex = 0;
	LPWSTR lpszStop = NULL;
	for (int nIndex = 0; nIndex < 40; nIndex += 2) {
		CString strByte;
		strByte.Format(L"0x%c%c", strHashString[nIndex], strHashString[nIndex + 1]);
		pByteData[nByteDataIndex++] = static_cast<BYTE>(_tcstol(strByte, &lpszStop, 16));
	}

	return true;
}

