package hayashi.yuu.register;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;

import javax.swing.JComboBox;

public class DeviceSelectItem extends DeviceItem implements FocusListener {
	Hashtable<String, String> prop;			// 設定データを保持する領域
	String name;

	public DeviceSelectItem(Hashtable<String, String> prop, String name, String[] items) {
		super(name);
		this.prop = prop;
		this.name = name;
		field = new JComboBox();
		((JComboBox)field).addFocusListener(this);
		for (int i=0; i < items.length; i++) {
			((JComboBox)field).addItem(items[i]);
		}
		createItem(name, items[0]);
	}

	@Override
	void setupField(String value) {
		this.value = value;
		prop.put(this.name, value);
		((JComboBox)field).setSelectedItem(value);
		add(field);
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		this.value = (String) ((JComboBox)this.field).getSelectedItem();
		CardRegister.logger.fine("[反映] "+ label.getText() +" = "+ this.value);
		prop.put(label.getText(), this.value);
	}

	/**
	 * このフィールドにカーソルが移ったときの処理
	 */
	public void focusGained(FocusEvent arg0) {
		// 何もしない
	}

	/**
	 * このフィールドから他のフィールドへカーソルが移った時の処理。
	 */
	public void focusLost(FocusEvent e) {
		actionPerformed(null);
	}
}
