package hayashi.yuu.register;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * public class PropertyItem extends JPanel implements ActionListener
 * @author hayashi
 *
 */
public abstract class DeviceItem extends JPanel implements ActionListener
{
	JLabel label;
	JComponent field;
	String value;		// 設定データを保持する領域
	public static final int ITEM_WIDTH_1 = 120;
	public static final int ITEM_WIDTH_2 = 80;
    public static final int LINE_WIDTH = ITEM_WIDTH_1 + ITEM_WIDTH_2;
    public static final int LINE_HEIGHT = 18;
    
    /**
     * コンストラクタ
     * @param prop2
     * @param name
     * @param editable
     */
	public DeviceItem(String name) {
		super(null);
		this.value = new String("");
	}
	
	void createItem(String name, String value) {
		this.value = value;
		setupLabel(name, value);
		setupField(value);
		
		label.setBounds(0, 0, ITEM_WIDTH_1 - 6, LINE_HEIGHT);
		field.setBounds(ITEM_WIDTH_1, 0, ITEM_WIDTH_2, LINE_HEIGHT);
		setPreferredSize(new Dimension(ITEM_WIDTH_1, LINE_HEIGHT));
	}
	
	JLabel setupLabel(String name, String value) {
		label = new JLabel(name, JLabel.RIGHT);
		add(label);
		return label;
	}
	
	/**
	 * コーディング例：
	 * 
	 * 	void setupField(String name, String value) {
	 * 		this.value = value;
	 * 		((JTextField)field).setText(value);
	 * 		field.setFont(new Font("MS UI Gothic", Font.PLAIN, 12));
	 * 		add(field);
	 * 	}
	 */
	abstract void setupField(String value);

	/**
	 * [反映]ボタンがクリックされたときの処理
	 * 	
	 * 	public void actionPerformed(ActionEvent e) {
	 * 		GuardixMonitor.logger.fine("[反映] "+ label.getText() +" = "+ text.getText());
	 * 		prop.setProperty(label.getText(), text.getText());
	 * 	}
	 * @param e
	 */
	public abstract void actionPerformed(ActionEvent e);
}
