package chemicraft;

import java.util.Random;

import net.minecraft.src.*;

public class ItemGasCollectingBottle extends ItemAtomInfoContainer {

	public ItemGasCollectingBottle(int id) {
		super(id);
		this.setMaxStackSize(1);
		this.setMaxDamage(2);
		this.setCreativeTab(ChemiCraft.instance.creativeTab);
	}

	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer){
		par1ItemStack.damageItem(1, par3EntityPlayer);

		this.atomInfo.update(par2World, par3EntityPlayer);
		if(this.atomInfo.isBelowY(129)){
			if(!par3EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.instance.atomsID, 1, 7))){
				par3EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.instance.atomsID, 1, 7));
			}
		}

		return par1ItemStack;
	}

	@Override
	public String getTextureFile() {
		return "/ChemiCraft/items/sprite.png";
	}

}
