package chemicraft.client;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraftforge.client.MinecraftForgeClient;
import chemicraft.ChemiCraft;
import chemicraft.CommonProxy;
import chemicraft.GuiChemicalCombinationTable;
import chemicraft.GuiDecompositionTable;
import chemicraft.GuiMaterialCraftingTable;
import chemicraft.GuiToolAndWeaponCraftingTable;
import chemicraft.TileEntityChemicalCombinationTable;
import chemicraft.TileEntityDecompositionTable;
import chemicraft.TileEntityMaterialCraftingTable;
import chemicraft.TileEntityToolAndWeaponCraftingTable;
import cpw.mods.fml.client.FMLClientHandler;

public class ClientProxy extends CommonProxy {

	@Override
	public void registerRenderInformation() {
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.blockChemicalCraftingTableTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.itemAtomsTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.itemCompoundsTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiChemicalCombinationTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiDecompositionTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiMaterialCraftingTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiToolAndWeaponCraftingTexture);
	}


	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if (!world.blockExists(x, y, z))
			return null;

		TileEntity tileEntity = world.getBlockTileEntity(x, y, z);
		if (tileEntity instanceof TileEntityDecompositionTable) {
			return new GuiDecompositionTable(player, (TileEntityDecompositionTable) tileEntity);
		}else if(tileEntity instanceof TileEntityChemicalCombinationTable){
			return new GuiChemicalCombinationTable(player, (TileEntityChemicalCombinationTable) tileEntity);
		}else if(tileEntity instanceof TileEntityToolAndWeaponCraftingTable){
			return new GuiToolAndWeaponCraftingTable(player, (TileEntityToolAndWeaponCraftingTable) tileEntity);
		}else if(tileEntity instanceof TileEntityMaterialCraftingTable){
			return new GuiMaterialCraftingTable(player, (TileEntityMaterialCraftingTable) tileEntity);
		}
		return null;
	}


	@Override
	public World getClientWorld() {
		return FMLClientHandler.instance().getClient().theWorld;
	}

}
