%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>boot</secondary>
@y
    <secondary>ブート</secondary>
@z

@x
    <title>Installation of the kernel</title>
@y
    <title>&InstallationOf1;カーネル&InstallationOf2;</title>
@z

@x
      <para>Here a temporary cross-compiled kernel will be built. When
      configuring it, select the minimal amount of options required to
      boot the target machine and build the final system. I.e., no support
      for sound, printers, etc. will be needed.</para>
@y
      <para>
      ここではクロスコンパイル用の一時的なカーネルを生成します。
      したがってカーネル設定においては必要最小限のオプションを選択するようにしてください。
      ターゲットマシンが起動でき最終システムを構築できるだけで十分だからです。
      つまり例えばサウンド、印刷機能といったものは必要になりません。
      </para>
@z

@x
      <para>Also, try to avoid the use of modules if possible, and don't
      use the resulting kernel image for production systems.</para>
@y
      <para>
      同様にモジュールの生成は極力避けてください。
      またここで生成されるカーネルイメージを最終システムにおいて利用しないでください。
      </para>
@z

@x
    <note os="kc"><para>A good starting place for setting up the kernel
    configuration is to run <command>make defconfig</command>. This will set the    base configuration to a good state that takes your current system
    architecture into account.</para>
@y
    <note os="kc"><para>
    カーネル設定を行うにあたって、分かりやすいやり方として <command>make defconfig</command> を実行する方法があります。
    これを実行することで基本的な設定がなされ、現在のシステム構成が考慮された、より良い設定が得られるかもしれません。
    </para>
@z

@x
    <para>Be sure to configure the following options as
    shown, or the system might not work correctly or boot at all.</para>
@y
    <para>
    以下のオプションについての有効無効を確認してください。
    不適切である場合にはシステムが正常動作しなかったり起動できなかったりするかもしれません。
    </para>
@z

@x
    <para os="ae">Configure the kernel via a menu-driven interface:</para>
@y
    <para os="ae">
    メニュー方式のインターフェースによりカーネルを設定します。
    </para>
@z

@x
    <para os="af">If the use of kernel modules can't be avoided, a file in
    <filename class="directory">/etc/modprobe.d</filename> may be needed.
    Information pertaining to modules and kernel configuration is
    located in the kernel documentation in the <filename
    class="directory">Documentation</filename> directory of the kernel
    sources tree. The <filename>modprobe.d</filename> man page may also
    be of interest.</para>
@y
    <para os="af">
    やむなくカーネルモジュールを利用する場合は <filename
    class="directory">/etc/modprobe.d</filename> ファイルが必要になります。
    モジュールやカーネル設定に関する情報はカーネルソースの <filename
    class="directory">Documentation</filename> ディレクトリにあるカーネルドキュメントを参照してください。
    また <filename>modprobe.d</filename> も有用です。
    </para>
@z

@x
    <para os="u">After kernel compilation is complete, additional steps are
    required to complete the installation. Some files need to be copied to
    the <filename class="directory">/tools/boot</filename> directory.</para>
@y
    <para os="u">
    カーネルのコンパイルが終わったら、インストールの完了に向けてあと少し作業を行います。
    <filename class="directory">/tools/boot</filename> ディレクトリにいくつかのファイルをコピーします。
    </para>
@z

@x
    <para os="v">Issue the following commands to install the kernel:</para>
@y
    <para os="v">
    以下のコマンドを実行してカーネルをインストールします。
    </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-kernel" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-kernel" role=""/>&Details2;
    </para>
@z