%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Adding the CLFS User</title>
@y
  <title>CLFS ユーザーの追加</title>
@z

@x
  <para>When logged in as user <systemitem class="username">root</systemitem>,
  making a single mistake can damage or destroy a system. Therefore, we
  recommend building the packages as an unprivileged user.
  You could use your own user name, but to make it easier to set up a clean
  work environment, create a new user called <systemitem
  class="username">clfs</systemitem> as a member of a new group (also named
  <systemitem class="groupname">clfs</systemitem>) and use this user during
  the installation process. As <systemitem class="username">root</systemitem>,
  issue the following commands to add the new user:</para>
@y
  <para>
  <systemitem class="username">root</systemitem> ユーザーでログインしていると、ちょっとした誤操作がもとで、システムを破壊する重大な事態につながることがあります。
  そこでパッケージのビルドにあたっては通常のユーザー権限にて作業することにします。
   あなた自身のユーザーを利用するのでも構いませんが、全く新しいユーザー環境として <systemitem
  class="username">clfs</systemitem> というユーザーを作成するのが分かりやすいでしょう。
  所属するグループも <systemitem class="groupname">clfs</systemitem> という名で作成します。
  ビルド作業においてはこのユーザーを利用していきます。
  そこで <systemitem class="username">root</systemitem> ユーザーになって、新たなユーザーを追加する以下のコマンドを実行します。
  </para>
@z

@x
    <title>The meaning of the command line options:</title>
@y
    <title>コマンドラインオプションの意味</title>
@z

@x
        <para>This makes <command>bash</command> the default shell for
        user <systemitem class="username">clfs</systemitem>.</para>
@y
        <para>
        <systemitem class="username">clfs</systemitem> ユーザーが利用するデフォルトのシェルを <command>bash</command> とします。
        </para>
@z

@x
          <para>The build instructions assume that the <command>bash</command>
          shell is in use.</para>
@y
          <para>
          ビルド手順においては <command>bash</command> シェルを既に用いているものとします。
          </para>
@z

@x
        <para>This option adds the new user to the
        <systemitem class="groupname">clfs</systemitem> group.</para>
@y
        <para>
        このオプションは <systemitem class="groupname">clfs</systemitem> グループに対して新たなユーザーを追加します。
        </para>
@z

@x
        <para>This option sets the user's home directory, but does not create
        it. We could have used <option>-m</option> to tell
        <command>useradd</command> to create the directory as well, but this
        would also copy the contents of the host system's
        <filename class="directory">/etc/skel</filename> directory into the new
        user's home. We would prefer to have a clean user environment, so we
        just create an empty directory after adding the user.</para>
@y
        <para>
        このオプションはユーザーのホームディレクトリを設定するものですが、ディレクトリ生成は行いません。
        <command>useradd</command> コマンドに <option>-m</option> オプションを与えて実行すればホームディレクトリの生成を行うこともできます。
        ただこの場合にはホストシステムの <filename
        class="directory">/etc/skel</filename> ディレクトリからファイルコピーが行われてしまいます。
        ここではクリーンなユーザー環境を生成することにします。
        つまりユーザー追加を行った後に空のホームディレクトリを生成するという方法をとります。
        </para>
@z

@x
        <para>This is the actual name for the created group and user.</para>
@y
        <para>
        生成するグループおよびユーザーの名称を与えます。
        </para>
@z

@x
  <para>To log in as <systemitem class="username">clfs</systemitem> (as
  opposed to switching to user <systemitem class="username">clfs</systemitem>
  when logged in as <systemitem class="username">root</systemitem>, which
  does not require the <systemitem class="username">clfs</systemitem> user
  to have a password), give <systemitem class="username">clfs</systemitem>
  a password:</para>
@y
  <para>
  <systemitem class="username">clfs</systemitem> ユーザーとしてログインするために <systemitem
  class="username">clfs</systemitem> に対するパスワードを設定します。
  (<systemitem class="username">root</systemitem> ユーザーでログインしている時に <systemitem
  class="username">clfs</systemitem> へのユーザー切り替えを行なう場合には <systemitem
  class="username">clfs</systemitem> ユーザーのパスワードは設定しておく必要はありません。)
  </para>
@z

@x
  <para>As <systemitem class="username">root</systemitem>,
  grant <systemitem class="username">clfs</systemitem> full access to
  <filename class="directory">${CLFS}/cross-tools</filename> and
  <filename class="directory">${CLFS}/tools</filename> by making <systemitem
  class="username">clfs</systemitem> the directorys' owner:</para>
@y
  <para>
  <systemitem class="username">root</systemitem> ユーザーとなり、<filename
  class="directory">${CLFS}/cross-tools</filename> と <filename
  class="directory">${CLFS}/tools</filename> のディレクトリ所有者を <systemitem
  class="username">clfs</systemitem> とすることにより <systemitem
  class="username">clfs</systemitem> のフルアクセス権限を与えます。
  </para>
@z

@x
  <para>If a separate working directory was created as suggested, run the
  following command as <systemitem class="username">root</systemitem> to
  give user <systemitem class="username">clfs</systemitem> ownership of this
  directory as well:</para>
@y
  <para>
  前述したような作業ディレクトリを作成している場合は <systemitem
  class="username">root</systemitem> ユーザーになって以下のコマンドを実行します。
  その作業ディレクトリに対しても所有者を <systemitem
  class="username">clfs</systemitem> ユーザーとします。
  </para>
@z

@x
  <para>Next, login as user <systemitem class="username">clfs</systemitem>.
  This can be done via a virtual console, through a display manager, or
  with the following substitute user command:</para>
@y
  <para>
  <systemitem class="username">clfs</systemitem> でログインします。
  これはディスプレイマネージャーを通じて仮想端末を用いることもできます。
  要は以下のユーザーコマンドに相当するログインを行います。
  </para>
@z

@x
  <para>The <quote><parameter>-</parameter></quote> instructs
  <command>su</command> to start a login shell as opposed to a non-login
  shell. The difference between these two types of shells can be found
  in detail in <filename>bash(1)</filename> and <command>info
  bash</command>.</para>
@y
  <para>
  パラメーター<quote><parameter>-</parameter></quote>は <command>su</command> コマンドの実行において、非ログイン (non-login) シェルではなく、ログインシェルを起動することを指示します。
  ログインシェルとそうでないシェルの違いについては <filename>bash(1)</filename> や <command>info bash</command> を参照してください。
  </para>
@z

@x
    <para>Until specified otherwise, all commands from this point on
    should be done as the <systemitem class="username">clfs</systemitem>
    user.</para>
@y
    <para>
    特に指定を行わない限りここから先のコマンド実行は、すべて <systemitem
    class="username">clfs</systemitem> ユーザーにより行っていくことになります。
    </para>
@z
