%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating the /etc/resolv.conf File</title>
@y
  <title>/etc/resolv.conf ファイルの生成</title>
@z

@x
    <para>If the system is going to be connected to the Internet, it will
    need some means of Domain Name Service (DNS) name resolution to
    resolve Internet domain names to IP addresses, and vice versa. This is
    best achieved by placing the IP address of the DNS server, available
    from the ISP or network administrator, into
    <filename>/etc/resolv.conf</filename>. If at least one of your network
    interfaces is going to be configured by DHCP then you may not need to
    create this file. By default DHCPCD will overwrite this file when it gets
    a new lease from the DHCP server. If you wish to manually configure your
    network interfaces or manually set your DNS using DHCP then create the
    file by running the following:</para>
@y
    <para>
    インターネットへの接続を行う場合には、ドメイン名サービス (domain name service; DNS) による名前解決を必要とします。
    これによりインターネットドメイン名を IP アドレスに、あるいはその逆の変換を行います。
    これを行うには ISP やネットワーク管理者が指定する DNS サーバーの割り振り IP アドレスを <filename>/etc/resolv.conf</filename> ファイルに設定します。
    以下のコマンドによりこのファイルを生成します。
    ネットワークインターフェースの一つでも DHCP に対して設定するのであれば、このファイルを生成しません。
    デフォルトで DHCPCD は、DHCP サーバーから新たなリースを得るごとにこのファイルを上書きします。
    ネットワークインターフェースを手動で設定したい場合や DHCP を利用した DNS を手動で設定したい場合は、以下のコマンドを実行してこのファイルを生成します。
    </para>
@z

@x
    <para>The <replaceable>domain</replaceable> statement can be omitted or
    replaced with a <replaceable>search</replaceable> statement. See the man
    page for resolv.conf for more details.</para>
@y
    <para>
    <replaceable>domain</replaceable> ステートメントは省略するか、<replaceable>search</replaceable> ステートメントで代用することが可能です。
    詳しくは resolv.conf の man ページを参照してください。
    </para>
@z

@x
    <para>Replace <replaceable>[IP address of the nameserver]</replaceable>
    with the IP address of the DNS most appropriate for the setup. There will
    often be more than one entry (requirements demand secondary servers for
    fallback capability). If you only need or want one DNS server, remove the
    second <emphasis>nameserver</emphasis> line from the file. The IP address
    may also be a router on the local network.</para>
@y
    <para>
    <replaceable>[IP address of the nameserver]</replaceable> (ネームサーバーの IP アドレス) の部分には、DNS が割り振る適切な IP アドレスを記述します。
    IP アドレスの設定は複数行う場合もあります。(代替構成を必要とするなら二次サーバーを設けることでしょう。)
    一つのサーバーのみで十分な場合は、二つめの <emphasis>nameserver</emphasis> の行は削除します。
    ローカルネットワークにおいてはルーターの IP アドレスを設定することになるでしょう。
    </para>
@z