%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating a File System on the Partition</title>
@y
  <title>ファイルシステムの生成</title>
@z

@x
  <para os="a">Now that a blank partition has been set up, the file system can be
  created. The most widely-used system in the Linux world is the second
  extended file system (ext2), but with newer high-capacity hard disks,
  journaling file systems are becoming increasingly popular. We will create
  an <systemitem class="filesystem">ext2</systemitem> file system.
  Instructions for other file systems can be found at
  <ulink url="&cblfs-root;index.php?section=6#File_System"/>.</para>
@y
  <para os="a">
  空のパーティションが準備できたのでファイルシステムを作ります。
  Linux において広く用いられるファイルシステムは ext2 (extended file system) です。
  より新しく大容量のハードディスクに対しては、ジャーナリングファイルシステムが一般的となりつつあります。
  本書では <systemitem class="filesystem">ext2</systemitem> ファイルシステムを生成することにします。
  他のファイルシステムの生成方法については <ulink url="&cblfs-root;index.php?section=6#File_System"/> を参照してください。
  </para>
@z

@x
  <para os="b">To create an <systemitem class="filesystem">ext2</systemitem> file
  system on the CLFS partition, run the following as
  <systemitem class="username">root</systemitem>:</para>
@y
  <para os="b">
  CLFS 用のパーティションに対して <systemitem
  class="filesystem">ext2</systemitem> ファイルシステムを生成するために、<systemitem
  class="username">root</systemitem> ユーザーになって以下のコマンドを実行します。
  </para>
@z

@x
  <para os="d">Replace <replaceable>[xxx]</replaceable> with the name of the CLFS
  partition (<filename class="devicefile">sda5</filename> in our previous
  example).</para>
@y
  <para os="d">
  <replaceable>[xxx]</replaceable> の部分は CLFS パーティション名に合わせて置き換えてください。
  (本書の例では <filename class="devicefile">sda5</filename> としています。)
  </para>
@z

@x
    <para>Some host distributions use custom features in their filesystem
    creation tools (E2fsprogs). This can cause problems when booting into
    your new CLFS system, as those features will not be supported by the
    CLFS-installed E2fsprogs; you will get an error similar to
    <computeroutput>unsupported filesystem features, upgrade your
    e2fsprogs</computeroutput>. To check if your host system uses custom
    enhancements, run the following command:</para>
@y
    <para>
    ホストとして利用する Linux ディストリビューションの中には、ファイルシステムを生成するツール (E2fsprogs) に特別な機能を実装しているものがあります。
    CLFS システムをブートする際に、それらの機能が原因で問題が発生する場合があります。
    そのような機能は CLFS においてインストールする E2fsprogs ではサポートしていません。
    おそらくは <computeroutput>unsupported filesystem features, upgrade your
    e2fsprogs</computeroutput>(サポートされていないファイルシステムです。 e2fsprogs をアップグレードしてください) といったエラーメッセージが表示されるはずです。
    ホストシステムが機能拡張しているかどうかを確認するには以下のコマンドを実行します。
    </para>
@z

@x
    <para>If the output contains features other than: dir_index; ext_attr; filetype;
    large_file; resize_inode or sparse_super then your host system may have custom
    enhancements. In that case, to avoid later problems, you should compile the
    stock E2fsprogs package and use the resulting binaries to re-create the
    filesystem on your CLFS partition. To do this, run the following commands
    as <systemitem class="username">root</systemitem>:</para>
@y
    <para>
    コマンドの出力結果の中に dir_index, ext_attr, filetype, large_file, resize_inode, sparse_super といったものとは異なるものが表示されていたら、あなたのホストシステムは機能拡張がなされていることを意味します。
    後に問題となりますので、純粋な E2fsprogs パッケージをコンパイルし、これを用いて CLFS パーティションのファイルシステムを再生成してください。
    <systemitem class="username">root</systemitem> ユーザーになって以下を実行します。
    </para>
@z

@x
  <para os="h">If you created a swap partition, you will need to initialize it
  for use by issuing the command below as
  <systemitem class="username">root</systemitem>:</para>
@y
  <para os="h">
  swap パーティションを生成した場合は初期化する必要があります。
  <systemitem class="username">root</systemitem> ユーザーになって以下のコマンドを実行します。
  </para>
@z

@x
  <para os="j">Replace <replaceable>[yyy]</replaceable> with the name of the
  swap partition. If you are using an existing swap partition, there is no
  need to format it.</para>
@y
  <para os="j">
  <replaceable>[yyy]</replaceable> の部分は swap パーティションの名に合わせて置き換えてください。
  既存の swap パーティションを利用する場合は初期化する必要はありません。
  </para>
@z