/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jp.co.connectone.eai.notes.log.LogAspect;
import jp.co.connectone.eai.notes.store.EAINotesBase;
import jp.co.connectone.eai.notes.store.NotesAddressDTO;
import jp.co.connectone.eai.notes.store.NotesDJXAddressDTO;
import jp.co.connectone.eai.notes.store.NotesDatabaseIndex;
import jp.co.connectone.eai.notes.store.NotesFolderIndex;
import jp.co.connectone.eai.notes.store.NotesObjectIndex;
import jp.co.connectone.eai.notes.store.NotesServiceInfo;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.AddressBookSearchCondition;
import jp.co.connectone.store.pim.IAddressBookStore;
import jp.co.connectone.store.pim.IAddressDTO;
import jp.co.connectone.store.pim.IAddressDTOComparator;
import jp.co.connectone.user.IAccountData;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.View;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class NotesAddressBookStoreImpl
extends EAINotesBase
implements IAddressBookStore {
    public static final IStoreID storeID;
    public static final String storeName = "Notes Addressbook Store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        NotesAddressBookStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(NotesAddressBookStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        NotesServiceInfo info = new NotesServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        String serverAddress2 = (String)h.get("server2");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        if (serverAddress2 != null) {
            info.setServerAddress2(serverAddress2);
        }
        return info;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new NotesServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IObjectIndex createNewAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO address) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void deleteAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IAddressDTO getAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        IAddressDTO l_objIAddressDTO = null;
        Document l_docAddBook = null;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_docAddBook = this.getDocumentByUNID(oid);
                l_objIAddressDTO = this.populateIAddressDTO(l_docAddBook);
            }
            catch (Exception e) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docAddBook != null) {
                    l_docAddBook.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_objIAddressDTO;
    }

    private IAddressDTO populateIAddressDTO(Document objDocAddBook) throws ServerDown, DataNotFound, IncorrectData {
        NotesAddressDTO l_objIAddressDTO = null;
        try {
            String altFullName = objDocAddBook.getItemValueString("AltFullName");
            if (altFullName == null || "".equals(altFullName)) {
                l_objIAddressDTO = new NotesAddressDTO();
            } else {
                NotesDJXAddressDTO djxDTO = new NotesDJXAddressDTO();
                djxDTO.setDjxDisplayName(this.trimDJXDisplayName(altFullName));
                l_objIAddressDTO = djxDTO;
            }
            l_objIAddressDTO.setOid((IObjectIndex)new NotesObjectIndex(objDocAddBook.getUniversalID()));
            l_objIAddressDTO.setTid(objDocAddBook.getUniversalID());
            l_objIAddressDTO.setFirstName(objDocAddBook.getItemValueString("FirstName"));
            l_objIAddressDTO.setFamilyName(objDocAddBook.getItemValueString("LastName"));
            l_objIAddressDTO.setDisplayName(this.getAccountStringFromFullname(objDocAddBook.getItemValueString("FullName")));
            l_objIAddressDTO.setEmail(String.valueOf(this.getAccountStringFromFullname(objDocAddBook.getItemValueString("FullName"))) + "@" + objDocAddBook.getItemValueString("MailDomain"));
            l_objIAddressDTO.setCompanyPhone(objDocAddBook.getItemValueString("OfficePhoneNumber"));
            l_objIAddressDTO.setCompanyName(objDocAddBook.getItemValueString("CompanyName"));
            l_objIAddressDTO.setCompanyAddress(String.valueOf(objDocAddBook.getItemValueString("OfficeState")) + objDocAddBook.getItemValueString("OfficeCity") + objDocAddBook.getItemValueString("OfficeStreetAddress") + objDocAddBook.getItemValueString("OfficeNumber"));
            l_objIAddressDTO.setMobilePhone(objDocAddBook.getItemValueString("CellPhoneNumber"));
            l_objIAddressDTO.setHomePhone(objDocAddBook.getItemValueString("PhoneNumber"));
        }
        catch (NullPointerException l_nullExObj) {
            throw new DataNotFound();
        }
        catch (NotesException l_notesExcepObj) {
            throw new ServerDown(l_notesExcepObj.text);
        }
        return l_objIAddressDTO;
    }

    private String trimDJXDisplayName(String dixDisplayName) {
        dixDisplayName = dixDisplayName.replaceFirst("CN=", "");
        dixDisplayName = dixDisplayName.replaceFirst("OU=", "");
        dixDisplayName = dixDisplayName.replaceFirst("O=", "");
        return dixDisplayName;
    }

    public IAddressDTO[] getAddressBookItems(IAccountData acc, ISearchDestination dest) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        View l_objViewMailUsers = null;
        Document l_objDocAddBook = null;
        IAddressDTO[] l_objIAddressDTO = null;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_objViewMailUsers = this.getView(dest.getFolder());
                l_objIAddressDTO = new IAddressDTO[]{};
                l_objDocAddBook = l_objViewMailUsers.getFirstDocument();
                ArrayList<IAddressDTO> list = new ArrayList<IAddressDTO>();
                while (l_objDocAddBook != null) {
                    list.add(this.populateIAddressDTO(l_objDocAddBook));
                    l_objDocAddBook = l_objViewMailUsers.getNextDocument(l_objDocAddBook);
                }
                l_objIAddressDTO = list.toArray(l_objIAddressDTO);
            }
            catch (NullPointerException l_nullExObj) {
                if (l_objViewMailUsers == null) {
                    throw new StoreNotFound(dest.getDatabase().getIndex().toString());
                }
                throw new DataNotFound();
            }
            catch (NotesException l_notesExObj) {
                String string = "NotesException:" + (Object)((Object)l_notesExObj);
                NotesAddressBookStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
        }
        finally {
            try {
                if (l_objDocAddBook != null && l_objDocAddBook != null) {
                    l_objDocAddBook.recycle();
                    l_objViewMailUsers.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_objIAddressDTO;
    }

    public IAddressDTO[] getAddressBookItemsByFTSearch(IAccountData acc, ISearchDestination dest, String searchByEnglish, String searchByJapanese) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        View l_objViewMailUsers = null;
        IAddressDTO[] l_objIAddressDTO = null;
        int maxDocs = 21;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_objViewMailUsers = this.getView(dest.getFolder());
                Set<IAddressDTO> addrSet = this.FTSearch(l_objViewMailUsers, searchByEnglish, maxDocs);
                if (addrSet.size() < maxDocs) {
                    Set<IAddressDTO> addrSetJ = this.FTSearch(l_objViewMailUsers, searchByJapanese, maxDocs);
                    addrSet.addAll(addrSetJ);
                }
                l_objIAddressDTO = new IAddressDTO[]{};
                l_objIAddressDTO = addrSet.toArray(l_objIAddressDTO);
            }
            catch (NullPointerException l_nullExObj) {
                if (l_objViewMailUsers == null) {
                    throw new StoreNotFound(dest.getDatabase().getIndex().toString());
                }
                throw new DataNotFound();
            }
            catch (NotesException l_notesExObj) {
                String string = "NotesException:" + (Object)((Object)l_notesExObj);
                NotesAddressBookStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
        }
        finally {
            try {
                if (l_objViewMailUsers != null) {
                    l_objViewMailUsers.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_objIAddressDTO;
    }

    private Set<IAddressDTO> FTSearch(View view, String query, int maxDocs) throws NotesException, HandleException {
        if (query == null) {
            return new TreeSet<IAddressDTO>();
        }
        if ("".equals(query = query.trim())) {
            return new TreeSet<IAddressDTO>();
        }
        Document l_objDocAddBook = null;
        TreeSet<IAddressDTO> addrSet = new TreeSet<IAddressDTO>((Comparator<IAddressDTO>)new IAddressDTOComparator(0, false));
        try {
            view.FTSearch(query, maxDocs);
            l_objDocAddBook = view.getFirstDocument();
            while (l_objDocAddBook != null) {
                IAddressDTO l_objNotesAddressDTO = this.populateIAddressDTO(l_objDocAddBook);
                addrSet.add(l_objNotesAddressDTO);
                l_objDocAddBook = view.getNextDocument(l_objDocAddBook);
            }
        }
        finally {
            if (l_objDocAddBook != null) {
                l_objDocAddBook.recycle();
            }
        }
        return addrSet;
    }

    public IAddressDTO[] searchAddressBook(IAccountData acc, ISearchFormula form) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        Iterator it = form.getSearchConditions().iterator();
        SearchCondition cond = null;
        ISearchType condType = null;
        String name = "";
        String searchByEnglish = "";
        String searchByJapanese = "";
        String prefix = "";
        String suffix = "";
        while (it.hasNext()) {
            cond = (SearchCondition)it.next();
            condType = cond.getType();
            if (condType == AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME) {
                name = (String)cond.getValue();
                searchByEnglish = "\"" + name + "*\"";
                searchByJapanese = "\"" + name + "\"";
                prefix = name;
            }
            if (condType == AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME) {
                name = (String)cond.getValue();
                searchByEnglish = "\"*" + name + "*\"";
                searchByJapanese = "\"" + name + "\"";
            }
            if (condType != AddressBookSearchCondition.CONDITION.TYPE_LASTNAME) continue;
            name = (String)cond.getValue();
        }
        IAddressDTO[] addrs = this.getAddressBookItemsByFTSearch(acc, form.getDest(), searchByEnglish, searchByJapanese);
        List<IAddressDTO> ar = this.narrowAddressBookItems(addrs, prefix, suffix);
        addrs = new IAddressDTO[]{};
        return ar.toArray(addrs);
    }

    private List<IAddressDTO> narrowAddressBookItems(IAddressDTO[] addresses, String prefix, String suffix) {
        ArrayList<IAddressDTO> addressList = new ArrayList<IAddressDTO>();
        int i = 0;
        while (i < addresses.length) {
            NotesAddressDTO addr = null;
            if (addresses[i] instanceof NotesAddressDTO && (addr = (NotesAddressDTO)addresses[i]).commonNameStartsWith(prefix) && addr.commonNameEndsWith(suffix)) {
                addressList.add(addresses[i]);
            }
            ++i;
        }
        return addressList;
    }

    public IObjectIndex updateAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO address) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        Document l_docObj = null;
        NotesObjectIndex rc = null;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_docObj = this.getDocumentByUNID(address.getOid());
                l_docObj.replaceItemValue("FirstName", (Object)address.getFirstName());
                l_docObj.replaceItemValue("LastName", (Object)address.getFamilyName());
                l_docObj.save();
                rc = new NotesObjectIndex(l_docObj.getUniversalID());
            }
            catch (NotesException l_notesExcepObj) {
                if (l_docObj != null && address != null) {
                    throw new UpdateFailed();
                }
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
            catch (NullPointerException l_objNullPointerException) {
                if (l_docObj != null) {
                    throw new IncorrectData("Invalid Details to Update Address Book!");
                }
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return rc;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteAddressBookItem(acc, dest, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAddressBookItems(acc, dest);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        throw new UnsupportedOperationException("get folder list on NotesAddressBook not supported.");
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getAddressBookItem(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula form) throws Exception {
        return this.searchAddressBook(acc, form);
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date searchDate) throws Exception {
        throw new UnsupportedOperationException("searchByDate on NotesAddressBook not supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject address) throws Exception {
        IObjectIndex rc = null;
        rc = address.isNew() ? this.createNewAddressBookItem(acc, dest, (IAddressDTO)address) : this.updateAddressBookItem(acc, dest, (IAddressDTO)address);
        return rc;
    }

    @Override
    protected String getElmentName() {
        return null;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        NotesFolderIndex folder = null;
        NotesDatabaseIndex db = null;
        switch (type) {
            case 2: {
                db = new NotesDatabaseIndex("names.nsf");
                folder = new NotesFolderIndex("Mail Users");
                break;
            }
            case 1: {
                this.initSession((NotesAccountData)acc);
                db = new NotesDatabaseIndex(this.getFilePath());
                folder = new NotesFolderIndex("($PeopleGroupsFlat)");
            }
        }
        return new BasicSearchDestination((IDatabaseIndex)db, folder);
    }

    private static final /* synthetic */ void debug_aroundBody0(NotesAddressBookStoreImpl notesAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(NotesAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(NotesAddressBookStoreImpl notesAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(NotesAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotesAddressBookStoreImpl.java", Class.forName("jp.co.connectone.eai.notes.store.NotesAddressBookStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 178);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 225);
    }
}

