/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.jdbc.store;

import java.util.ArrayList;
import jp.co.connectone.eai.jdbc.store.EAIJdbcBase;
import jp.co.connectone.eai.jdbc.store.HSQLServiceInfo;
import jp.co.connectone.eai.jdbc.store.IJdbcDBStore;
import jp.co.connectone.eai.jdbc.store.JdbcDriverServiceInfo;
import jp.co.connectone.eai.jdbc.store.JdbcJNDIServiceInfo;
import jp.co.connectone.eai.jdbc.store.MSSQLServiceInfo;
import jp.co.connectone.eai.jdbc.store.MYSQLServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.user.IAccountData;

public class JdbcDBStoreImpl
extends EAIJdbcBase
implements IJdbcDBStore {
    public static final IStoreID storeID = new SimpleStoreID(JdbcDBStoreImpl.class.getName());
    public static final String storeName = "JDBC Database Store";

    public IRecordObject[] getDataSet(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        try {
            return this.getAllDatas(acc, dest);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
    }

    public FolderMetadata[] getTableList(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getFolderList(acc, dest);
    }

    public IRecordObject[] getUniqueIndexes(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        ArrayList<String> columnsToGet = new ArrayList<String>();
        columnsToGet.add("OID");
        try {
            return super.getAllDatas(acc, dest, columnsToGet);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
    }

    public String getName() throws Exception {
        return storeName;
    }

    @Override
    public IServiceInfo getServiceInfo(IJdbcDBStore.EnumEngineType engine) throws Exception {
        switch (engine) {
            case ENGINE_TYPE_HSQLDB: {
                return new HSQLServiceInfo(storeID, storeName);
            }
            case ENGINE_TYPE_MSSQL: {
                return new MSSQLServiceInfo(storeID, storeName);
            }
            case ENGINE_TYPE_MYSQL: {
                return new MYSQLServiceInfo(storeID, storeName);
            }
        }
        throw new IllegalArgumentException("Non-supported EngineType.");
    }

    @Override
    public IServiceInfo getServiceInfo() throws Exception {
        IServiceInfo rc = null;
        rc = this.useJNDI ? new JdbcJNDIServiceInfo(storeID, storeName) : JdbcDriverServiceInfo.getInstance(storeID, storeName);
        return rc;
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        throw new HandleException("no preset destination supported.");
    }

    public FolderMetadata[] getFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getTableList(acc, dest);
    }
}

