/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.util;

import com.microsoft.schemas.exchange.services._2006.types.AndType;
import com.microsoft.schemas.exchange.services._2006.types.ArrayOfRecipientsType;
import com.microsoft.schemas.exchange.services._2006.types.AttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BasePathToElementType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarViewType;
import com.microsoft.schemas.exchange.services._2006.types.ConstantValueType;
import com.microsoft.schemas.exchange.services._2006.types.ContainmentComparisonType;
import com.microsoft.schemas.exchange.services._2006.types.ContainmentModeType;
import com.microsoft.schemas.exchange.services._2006.types.ContainsExpressionType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdNameType;
import com.microsoft.schemas.exchange.services._2006.types.EmailAddressType;
import com.microsoft.schemas.exchange.services._2006.types.FieldURIOrConstantType;
import com.microsoft.schemas.exchange.services._2006.types.FileAttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.ImportanceChoicesType;
import com.microsoft.schemas.exchange.services._2006.types.IndexBasePointType;
import com.microsoft.schemas.exchange.services._2006.types.IndexedPageViewType;
import com.microsoft.schemas.exchange.services._2006.types.IsEqualToType;
import com.microsoft.schemas.exchange.services._2006.types.IsGreaterThanOrEqualToType;
import com.microsoft.schemas.exchange.services._2006.types.IsLessThanOrEqualToType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfAttachmentsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseFolderIdsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseItemIdsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfPathsToElementType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfRequestAttachmentIdsType;
import com.microsoft.schemas.exchange.services._2006.types.ObjectFactory;
import com.microsoft.schemas.exchange.services._2006.types.OrType;
import com.microsoft.schemas.exchange.services._2006.types.PathToUnindexedFieldType;
import com.microsoft.schemas.exchange.services._2006.types.RestrictionType;
import com.microsoft.schemas.exchange.services._2006.types.SearchExpressionType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import jp.co.connectone.eai.exchews.ews.EWSDateFormat;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsFolderMetadata;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.util.ExchEWSImportance;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.MailAddress;

public class ExchEWSTranslator {
    protected static final ObjectFactory typesObjectFactory = new ObjectFactory();
    protected static final com.microsoft.schemas.exchange.services._2006.messages.ObjectFactory messagesObjectFactory = new com.microsoft.schemas.exchange.services._2006.messages.ObjectFactory();

    public static NonEmptyArrayOfAttachmentsType createArrayOfAttachmentsType(AttachmentDTO[] attach) {
        NonEmptyArrayOfAttachmentsType rc = typesObjectFactory.createNonEmptyArrayOfAttachmentsType();
        List list = rc.getItemAttachmentOrFileAttachment();
        AttachmentDTO[] attachmentDTOArray = attach;
        int n = attach.length;
        int n2 = 0;
        while (n2 < n) {
            AttachmentDTO src = attachmentDTOArray[n2];
            FileAttachmentType item = new FileAttachmentType();
            item.setContent(src.getFileBody());
            item.setName(src.getFileName());
            list.add(item);
            ++n2;
        }
        return rc;
    }

    public static ExchewsFolderMetadata createDistinguishedFolder(FOLDER_TYPE type) {
        ExchewsFolderMetadata rc = new ExchewsFolderMetadata();
        ExchewsFolderIndex idx = new ExchewsFolderIndex();
        switch (type) {
            case INBOX: {
                idx.setIndex(DistinguishedFolderIdNameType.INBOX);
                break;
            }
            case SENTBOX: {
                idx.setIndex(DistinguishedFolderIdNameType.OUTBOX);
            }
        }
        return rc;
    }

    public static ExchewsObjectIndex createIndex(String id) {
        ItemIdType index = new ItemIdType();
        index.setId(id);
        return new ExchewsObjectIndex(index);
    }

    public static Date convertEWSDateTime2JavaDate(XMLGregorianCalendar src) {
        if (src == null) {
            return null;
        }
        return src.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar convertJavaDate2EWSDateTime(Date src) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(src);
        XMLGregorianCalendar rc = null;
        try {
            rc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        }
        catch (Exception e) {
            Log.error((String)"Error on convert date to XMLGregorianCalendar.", (Throwable)e);
        }
        return rc;
    }

    public static String javaDate2EWSDateStr(Date date) {
        if (date == null) {
            return null;
        }
        EWSDateFormat sdf = new EWSDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    public static String javaDate2EWSDateStr_DateTop(Date date) {
        if (date == null) {
            return null;
        }
        EWSDateFormat sdf = new EWSDateFormat(3);
        String dateStr = sdf.format(date);
        try {
            sdf.setFormatType(2);
            Date topDate = sdf.parse(dateStr);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateStr = sdf.format(topDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dateStr;
    }

    public static String javaDate2EWSDateStr_DateEnd(Date date) {
        if (date == null) {
            return null;
        }
        EWSDateFormat sdf = new EWSDateFormat(4);
        String dateStr = sdf.format(date);
        try {
            sdf.setFormatType(2);
            Date endDate = sdf.parse(dateStr);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateStr = sdf.format(endDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dateStr;
    }

    public static MailAddress[] convertEWSArrayOfRecipientsType2MailBoxes(ArrayOfRecipientsType ar) {
        if (ar == null) {
            return null;
        }
        List src = ar.getMailbox();
        ArrayList<MailAddress> l = new ArrayList<MailAddress>();
        for (EmailAddressType add : src) {
            l.add(ExchEWSTranslator.convertEWSMailBox2MailAddress(add));
        }
        return l.toArray(new MailAddress[0]);
    }

    public static MailAddress convertEWSMailBox2MailAddress(EmailAddressType mailbox) {
        if (mailbox == null) {
            return null;
        }
        return new MailAddress(mailbox.getName(), mailbox.getEmailAddress());
    }

    public static EmailAddressType convertMailAddress2EWSMailBox(MailAddress addr) {
        if (addr == null) {
            return null;
        }
        EmailAddressType mailbox = new EmailAddressType();
        mailbox.setName(addr.getNamePart());
        mailbox.setEmailAddress(addr.getAddressPart());
        return mailbox;
    }

    public static ExchEWSImportance convertEWSImportantType2C1Importance(ImportanceChoicesType importance) {
        if (importance == null) {
            return null;
        }
        switch (importance) {
            case HIGH: {
                return ExchEWSImportance.HIGH;
            }
            case LOW: {
                return ExchEWSImportance.LOW;
            }
        }
        return ExchEWSImportance.NORMAL;
    }

    public static ImportanceChoicesType convertC1Importance2EWSImportantType(ExchEWSImportance importance) {
        if (importance == null) {
            return null;
        }
        switch (importance) {
            case HIGH: {
                return ImportanceChoicesType.HIGH;
            }
            case LOW: {
                return ImportanceChoicesType.LOW;
            }
        }
        return ImportanceChoicesType.NORMAL;
    }

    public static JAXBElement<? extends SearchExpressionType> createIsLessThanOrEqualTo(UnindexedFieldURIType itemType, String itemValue) {
        IsLessThanOrEqualToType iltett = new IsLessThanOrEqualToType();
        iltett.setPath(ExchEWSTranslator.createFieldURI(itemType));
        iltett.setFieldURIOrConstant(ExchEWSTranslator.createFieldConstant(itemValue));
        return typesObjectFactory.createIsLessThanOrEqualTo(iltett);
    }

    public static JAXBElement<? extends SearchExpressionType> createIsGreaterThanOrEqualTo(UnindexedFieldURIType itemType, String itemValue) {
        IsGreaterThanOrEqualToType igtett = new IsGreaterThanOrEqualToType();
        igtett.setPath(ExchEWSTranslator.createFieldURI(itemType));
        igtett.setFieldURIOrConstant(ExchEWSTranslator.createFieldConstant(itemValue));
        return typesObjectFactory.createIsGreaterThanOrEqualTo(igtett);
    }

    public static SearchExpressionType createContains(UnindexedFieldURIType itemType, String itemValue) {
        ContainsExpressionType iett = new ContainsExpressionType();
        iett.setPath(ExchEWSTranslator.createFieldURI(itemType));
        ConstantValueType constant = new ConstantValueType();
        constant.setValue(itemValue);
        iett.setConstant(constant);
        iett.setContainmentComparison(ContainmentComparisonType.LOOSE_AND_IGNORE_CASE_AND_IGNORE_NON_SPACE);
        iett.setContainmentMode(ContainmentModeType.SUBSTRING);
        return iett;
    }

    public static JAXBElement<? extends SearchExpressionType> createIsEqualTo(UnindexedFieldURIType itemType, String itemValue) {
        IsEqualToType iett = new IsEqualToType();
        iett.setPath(ExchEWSTranslator.createFieldURI(itemType));
        iett.setFieldURIOrConstant(ExchEWSTranslator.createFieldConstant(itemValue));
        return typesObjectFactory.createIsEqualTo(iett);
    }

    public static FieldURIOrConstantType createFieldConstant(String itemDefValue) {
        ConstantValueType itemToGet = new ConstantValueType();
        itemToGet.setValue(itemDefValue);
        FieldURIOrConstantType itemConst = new FieldURIOrConstantType();
        itemConst.setConstant(itemToGet);
        return itemConst;
    }

    public static JAXBElement<? extends BasePathToElementType> createFieldURI(UnindexedFieldURIType fieldDefValue) {
        PathToUnindexedFieldType itemClass = new PathToUnindexedFieldType();
        itemClass.setFieldURI(fieldDefValue);
        JAXBElement itemClassPath = typesObjectFactory.createFieldURI(itemClass);
        return itemClassPath;
    }

    public static AndType createAnd(JAXBElement<? extends SearchExpressionType> ... elem) {
        AndType at = new AndType();
        JAXBElement<? extends SearchExpressionType>[] jAXBElementArray = elem;
        int n = elem.length;
        int n2 = 0;
        while (n2 < n) {
            JAXBElement<? extends SearchExpressionType> e = jAXBElementArray[n2];
            at.getSearchExpression().add(e);
            ++n2;
        }
        return at;
    }

    public static RestrictionType createRestriction(SearchExpressionType ex) {
        RestrictionType rt = new RestrictionType();
        JAXBElement rat = null;
        if (ex instanceof AndType) {
            AndType at = (AndType)ex;
            rat = typesObjectFactory.createAnd(at);
        } else if (ex instanceof OrType) {
            OrType ot = (OrType)ex;
            rat = typesObjectFactory.createOr(ot);
        } else if (ex instanceof ContainsExpressionType) {
            ContainsExpressionType ct = (ContainsExpressionType)ex;
            rat = typesObjectFactory.createContains(ct);
        }
        rt.setSearchExpression(rat);
        return rt;
    }

    public static NonEmptyArrayOfPathsToElementType createAdditionalProperties(UnindexedFieldURIType ... fieldTypes) {
        NonEmptyArrayOfPathsToElementType props = new NonEmptyArrayOfPathsToElementType();
        UnindexedFieldURIType[] unindexedFieldURITypeArray = fieldTypes;
        int n = fieldTypes.length;
        int n2 = 0;
        while (n2 < n) {
            UnindexedFieldURIType fieldType = unindexedFieldURITypeArray[n2];
            PathToUnindexedFieldType ptufta = new PathToUnindexedFieldType();
            ptufta.setFieldURI(fieldType);
            JAXBElement p = typesObjectFactory.createFieldURI(ptufta);
            props.getPath().add(p);
            ++n2;
        }
        return props;
    }

    public static NonEmptyArrayOfRequestAttachmentIdsType createAttachIdList(List<AttachmentType> attachItems) {
        NonEmptyArrayOfRequestAttachmentIdsType ids = new NonEmptyArrayOfRequestAttachmentIdsType();
        List idl = ids.getAttachmentId();
        for (AttachmentType item : attachItems) {
            idl.add(item.getAttachmentId());
        }
        return ids;
    }

    public static NonEmptyArrayOfBaseItemIdsType createItemIdList(ItemIdType ... idTypes) {
        NonEmptyArrayOfBaseItemIdsType ids = new NonEmptyArrayOfBaseItemIdsType();
        List idl = ids.getItemIdOrOccurrenceItemIdOrRecurringMasterItemId();
        ItemIdType[] itemIdTypeArray = idTypes;
        int n = idTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ItemIdType idType = itemIdTypeArray[n2];
            idl.add(idType);
            ++n2;
        }
        return ids;
    }

    public static NonEmptyArrayOfBaseFolderIdsType createFolderIds(BaseFolderIdType ... ids) {
        NonEmptyArrayOfBaseFolderIdsType folderIds = new NonEmptyArrayOfBaseFolderIdsType();
        List idList = folderIds.getFolderIdOrDistinguishedFolderId();
        BaseFolderIdType[] baseFolderIdTypeArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            BaseFolderIdType id = baseFolderIdTypeArray[n2];
            idList.add(id);
            ++n2;
        }
        return folderIds;
    }

    public static IndexedPageViewType createEWSParamPaging(int indexOffset, int pagingSize) {
        IndexedPageViewType index = new IndexedPageViewType();
        index.setBasePoint(IndexBasePointType.BEGINNING);
        index.setOffset(indexOffset);
        index.setMaxEntriesReturned(Integer.valueOf(pagingSize));
        return index;
    }

    public static MailAddress convertEWSArrayOfRecipientsType2SingleMailAddress(ArrayOfRecipientsType ar) {
        if (ar == null) {
            return null;
        }
        List src = ar.getMailbox();
        if (src == null) {
            return null;
        }
        EmailAddressType add = (EmailAddressType)src.get(0);
        if (add == null) {
            return null;
        }
        String displayName = add.getName();
        String addressPart = add.getEmailAddress();
        return new MailAddress(displayName, addressPart);
    }

    public static CalendarViewType createCalendarViewType(Date date) {
        CalendarViewType cal = new CalendarViewType();
        EWSDateFormat sdf1 = new EWSDateFormat(3);
        String dateStr = sdf1.format(date);
        sdf1.setFormatType(2);
        try {
            cal.setStartDate(ExchEWSTranslator.convertJavaDate2EWSDateTime(sdf1.parse(dateStr)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        EWSDateFormat sdf2 = new EWSDateFormat(4);
        dateStr = sdf2.format(date);
        sdf2.setFormatType(2);
        try {
            cal.setEndDate(ExchEWSTranslator.convertJavaDate2EWSDateTime(sdf2.parse(dateStr)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return cal;
    }

    public static enum FOLDER_TYPE {
        INBOX,
        SENTBOX;

    }
}

