/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.socket;

import java.util.Vector;
import jp.co.connectone.eai.pop3.exception.ServerCommunicationException;
import jp.co.connectone.eai.pop3.socket.Pop3ProtocolSocketImpl;
import jp.co.connectone.eai.pop3.socket.UidlElement;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.log.Log;

public class SocketBasedPop3BaseImpl {
    protected Pop3ProtocolSocketImpl socket = null;
    protected Vector<UidlElement> cacheUidls = null;
    protected String userID;
    protected String password;
    protected String serverAddress;
    protected String serverAddress2;
    protected int port;

    public SocketBasedPop3BaseImpl() {
        try {
            this.socket = Pop3ProtocolSocketImpl.getInstance();
        }
        catch (HandleException e) {
            Log.error((String)"couldn't instanciate Pop3ProtocolSocketImpl.", (Throwable)e);
        }
    }

    protected void setAccount(String userId, String passwd, String serverName1, String serverName2, int port) {
        this.userID = userId;
        this.password = passwd;
        this.serverAddress = serverName1;
        this.serverAddress2 = serverName2;
        this.port = port;
    }

    private boolean errorQuit() throws NoSuchRights {
        this.close();
        throw new NoSuchRights("POP Authentication Failed.");
    }

    protected boolean open() throws HandleException {
        if (this.userID == null) {
            throw new HandleException("call setAccount first.");
        }
        if (this.socket == null) {
            throw new HandleException("socket is null. please make instance again.");
        }
        this.socket.connect(this.serverAddress, this.serverAddress2);
        boolean f = this.socket.doUser(this.userID);
        if (!f) {
            return this.errorQuit();
        }
        f = this.socket.doPass(this.password);
        if (!f) {
            return this.errorQuit();
        }
        String[] rc = this.socket.doUidl();
        if (rc == null) {
            throw new ServerCommunicationException("returns POP ERR on doUidl.");
        }
        this.cacheUidls = new Vector();
        String[] stringArray = rc;
        int n = rc.length;
        int n2 = 0;
        while (n2 < n) {
            String uidl = stringArray[n2];
            this.cacheUidls.add(new UidlElement(uidl));
            ++n2;
        }
        return true;
    }

    protected void close() {
        if (this.cacheUidls != null) {
            this.cacheUidls = null;
        }
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        try {
            this.socket.doQuit();
        }
        catch (HandleException e) {
            Log.error((String)"error on QUIT command error.", (Throwable)e);
        }
        this.socket.disconnect();
    }

    public Vector<UidlElement> getUIDLList() throws HandleException {
        Vector<UidlElement> list = null;
        try {
            this.open();
            list = this.cacheUidls;
            this.close();
            return list;
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    protected int reverseIndex(int idx, int size) {
        return size - idx - 1;
    }

    public String getTopByUidlIndex(Vector<UidlElement> uidlList, int idx) throws HandleException {
        String rc = null;
        this.checkUidlListNotEmpty(uidlList);
        try {
            this.open();
            int actualUidlIdx = this.checkIdxActual(idx, uidlList);
            if (actualUidlIdx >= 0 && (rc = this.socket.doTop(actualUidlIdx)) == null) {
                throw new ServerCommunicationException("returns POP ERR on doTop.");
            }
            this.close();
            return rc;
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    public String getTopByUidlIndexR(Vector<UidlElement> uidlList, int idx) throws HandleException {
        this.checkUidlListNotEmpty(uidlList);
        idx = this.reverseIndex(idx, uidlList.size());
        return this.getTopByUidlIndex(uidlList, idx);
    }

    protected void checkUidlListNotEmpty(Vector<UidlElement> uidlList) throws HandleException {
        if (uidlList == null) {
            uidlList = this.getUIDLList();
        } else if (uidlList.size() == 0) {
            uidlList = this.getUIDLList();
        }
    }

    protected Vector<UidlElement> checkUidlListNotEmptyWithoutOpen(Vector<UidlElement> uidlList) throws HandleException {
        if (uidlList == null) {
            uidlList = this.cacheUidls;
        } else if (uidlList.size() == 0) {
            uidlList = this.cacheUidls;
        }
        return uidlList;
    }

    public String getRetrByUidlIndex(Vector<UidlElement> uidlList, int idx) throws HandleException {
        String rc = null;
        this.checkUidlListNotEmpty(uidlList);
        try {
            this.open();
            int actualUidlIdx = this.checkIdxActual(idx, uidlList);
            if (actualUidlIdx >= 0 && (rc = this.socket.doRetr(actualUidlIdx)) == null) {
                throw new ServerCommunicationException("returns POP ERR on doRetr.");
            }
            this.close();
            return rc;
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    public String getRetrByUidlIndexR(Vector<UidlElement> uidlList, int idx) throws HandleException {
        this.checkUidlListNotEmpty(uidlList);
        idx = this.reverseIndex(idx, uidlList.size());
        return this.getRetrByUidlIndex(uidlList, idx);
    }

    protected String getTopByUidlIndexWithoutOpen(Vector<UidlElement> uidlList, int idx) throws HandleException {
        String rc = null;
        int actualUidlIdx = this.checkIdxActual(idx, uidlList);
        if (actualUidlIdx >= 0 && (rc = this.socket.doTop(actualUidlIdx)) == null) {
            throw new ServerCommunicationException("returns POP ERR on doTop.");
        }
        return rc;
    }

    private int convertUidl2Idx(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        this.checkUidlListNotEmpty(uidlList);
        int idx = uidlList.indexOf(new UidlElement(uidl));
        if (idx == -1) {
            throw new IncorrectData("given UIDL should be in given uidlList.");
        }
        return idx;
    }

    public String getTopByUidl(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        int idx = this.convertUidl2Idx(uidlList, uidl);
        return this.getTopByUidlIndex(uidlList, idx);
    }

    protected String getTopByUidlWithoutOpen(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        int idx = this.convertUidl2Idx(uidlList, uidl);
        return this.getTopByUidlIndexWithoutOpen(uidlList, idx);
    }

    public String getRetrByUidl(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        int idx = this.convertUidl2Idx(uidlList, uidl);
        return this.getRetrByUidlIndex(uidlList, idx);
    }

    public void delete(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        int idx = this.convertUidl2Idx(uidlList, uidl);
        try {
            this.open();
            this.socket.doDelete(idx);
            this.close();
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    private int checkIdxActual(int idx, Vector<UidlElement> uidlList) {
        UidlElement target = uidlList.get(idx);
        return this.cacheUidls.indexOf(target);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getServerAddress2() {
        return this.serverAddress2;
    }

    public void setServerAddress2(String serverAddress2) {
        this.serverAddress2 = serverAddress2;
    }
}

