package jp.co.connectone.webproxy.ui.action;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.http.*;

import jp.co.connectone.common.MailTool;
import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.store.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.webapps.commandenv.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.webapps.struts.*;
import jp.co.connectone.webapps.tools.*;
import jp.co.connectone.webproxy.ui.logic.*;

import org.apache.struts.action.*;

import jp.co.connectone.webproxy.ui.DTOParseHelper.WebExch2kScheduleParseHelper;

/**
 * @author amanot
 *
 */
public class ExchewsMenuAction extends ExchewsAction
{

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#setArgs()
	 */
	protected void setArgs(CommandEnvSet env,DynaActionForm form)
	{
		String cmd = form.getString("cmd");
		String fc = form.getString("fc");
		String d = form.getString("d");
		Integer fidx = (Integer)form.get("fidx");
		Integer midx = (Integer)form.get("midx");
		Integer aidx = (Integer)form.get("aidx");
		Integer cp = (Integer)form.get("cp");
		String name = form.getString("name");
		String at = form.getString("at");
		String submit = form.getString("submit");
Log.debug("submit="+submit);
		if (cmd!=null)if (cmd.length()>0)env.put("cmd",cmd);
		if (fc!=null)if (fc.length()>0)env.put("fc",fc);
		if (d!=null)if (d.length()>0)env.put("date",d);
		if (fidx!=null)env.put("fidx",fidx);
		if (midx!=null)env.put("midx",midx);
		if (aidx!=null)env.put("aidx",aidx);
		if (cp!=null)env.put("cp",cp);
		if (name!=null)if (name.length()>0)env.put("name",name);
		if (at!=null)if (at.length()>0)env.put("at",at);
		if (submit!=null)if (submit.length()>0)env.put("submit",submit);
		
		env.put("name", "");
		if (name!=null)if (name.length()>0)env.put("name",name);
		env.put("submit", "");
		if (submit!=null)if (submit.length()>0)env.put("submit",submit);

	}

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#actionLogic(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward actionLogic(CommandEnvSet env,ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception
	{

		String cmd = env.getString("cmd");
		String fc = env.getString("fc");
Log.debug("cmd="+cmd+",fc="+fc);
		String dateStr = env.getString("date");
		Date date = null;
		if (dateStr==null) {
			date = new Date();
		}
		else if (dateStr.length()==0) {
			date = new Date();
		}
		else {
			DateControler dc = new DateControler(dateStr);
			date = dc.getDate();
		}
		request.setAttribute("date",date);

		try {
			if (cmd.equalsIgnoreCase(CMD_INBOX_MAIL)) {
				return processInboxMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_FOLDER_MAIL)) {
				return processFolderMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_MAIL_SEARCH)) {
				return mapping.findForward("MailSearch");
			}
			if (cmd.equalsIgnoreCase(CMD_NEW_MAIL)) {
				return prepareNewMail(env,request,mapping,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL)) {
				return processMail(env,form,request,mapping,fc,"NewMailSent");
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL2)) {
				return processMail(env,form,request,mapping,fc,"ReplyMailSent");
			}
			if (cmd.equalsIgnoreCase(CMD_SCHEDULE)) {
				return processSchedule(env,mapping,request,fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_SCHEDULE)) {
				return processCreateSchedule(env,form,request,mapping,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_OTH_SCH)) {
				return processOtherSchedule(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_ADDR_MENU)) {
				return processAddressBook(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_TASK)) {
				return processTask(env,form,mapping, request,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_MEMO)) {
				return processMemo(env,form,mapping, request,fc);
			}
		}
		catch (NoSuchRights nsr) {
			String userid=env.getString("u");
			Log.info("user "+userid+" Access Denied", nsr);
			return mapping.findForward("authError");
		}
		catch (ServerDown sd) {
			if (sd.getMessage().indexOf("LDAP")>0) {
				return mapping.findForward("authError");
			} else if (sd.getMessage().indexOf("HttpException")>0 && sd.getMessage().indexOf("403")>0) {
				return mapping.findForward("serverAuthError");
			}
			return mapping.findForward("serverError");
		}
		
		return mapping.findForward("error");
	}

	private ActionForward processAddressBook(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request,String fc,Date date) throws Exception
	{
		if (fc.equalsIgnoreCase("init")) {
			return mapping.findForward("AddrSearch");
		}
		if (fc.equalsIgnoreCase("list")) {
			String addressType = env.getString("at");
			String name = env.getString("name");
			if (addressType.equalsIgnoreCase("g")) {
				setList(env,request,searchActiveDirectory(env,name));
			}
			else {
				setList(env,request,searchAddressBook(env,name));
			}
			return mapping.findForward("AddrList");
		}
		if (fc.equalsIgnoreCase("view")) {
			String addressType = env.getString("at");
			Integer idx = (Integer)env.get("midx");
			IndexList idxList = (IndexList)env.get("eList");
			IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
			int mode = 0;
			if (addressType.equalsIgnoreCase("g")) {
				mode = Controler.COMMON_ADDRESSBOOK;
			}
			else {
				mode = Controler.PERSONAL_ADDRESSBOOK;
			}
			WebAddressParseHelper dto = ctrl.getAddressBookItem(env.getString("u"),env.getString("p"),mid,mode);
			addrAttrsSet(env,request,dto);
			return mapping.findForward("AddrDetail");
		}
		
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processOtherSchedule(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request,String fc,Date date) throws Exception
	{
		if (fc.equalsIgnoreCase("init")) {
			return mapping.findForward("OtherSche");
		}
		if (fc.equalsIgnoreCase("search")) {
			String name = env.getString("name");
			setList(env,request,searchActiveDirectory(env,name));
			env.put("otherAddress",null);
			return mapping.findForward("OtherScheNameList");
		}
		if (fc.equalsIgnoreCase("list")) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.schedate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			    DateControler dc = new DateControler(date);
			    String dateStr = dc.getDateStr();
			    env.put("date", dateStr);
			}
			IAddressDTO addr = (IAddressDTO)env.get("otherAddress");
			if (addr == null) {
				addr = getAddressBookItem(env,"g");
				if (addr==null) {
					return mapping.findForward("error");
				}
				env.put("otherAddress",addr);
			}
			request.setAttribute("address",addr);
			
			StrutsArrayList sal = null;

			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.schedate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			    DateControler dc = new DateControler(date);
			    String dateStr = dc.getDateStr();
			    env.put("date", dateStr);
			}

			try{
				IObjectIndex sid = new ExchewsObjectIndex(addr.getEmail());
				sal = searchOtheronesScheduleList(env,sid,date);
			}
			catch(jp.co.connectone.exception.NoSuchRights nsr){
				return mapping.findForward("ErrorOtherSch");
			}
			catch(jp.co.connectone.exception.ServerDown sd){
				return mapping.findForward("ErrorOtherSch");
			}
			setList(env,request,sal);
			return mapping.findForward("OtherScheList");
		}
		if (fc.equalsIgnoreCase("view")) {
			IAddressDTO addr = (IAddressDTO)env.get("otherAddress");
			WebScheduleParseHelper sche = getOtheronesSchedule(env,new ExchewsObjectIndex(addr.getEmail()));
			scheduleAttrsSet(env,request, sche);
			int cp = ((Integer)env.get("cp")).intValue();
			if (cp>0) {
				return mapping.findForward("OtherScheDetail2");
			}
			return mapping.findForward("OtherScheDetail");
		}
		return mapping.findForward("error");
	}

	private boolean dateValidate(Date date,String d)
	{
		if (date==null) return false;// unexpected error
		if (d==null) return true;// no date arg requested.. default is today
		SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
		
		String tmpd = f.format(date);
		if (d.equals(tmpd)) return true;// date made from d equals d... validated.
		return false;// in case d is not valid date format
	}
	
	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processSchedule(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request,String fc,Date date) throws Exception
	{
		if (fc.equalsIgnoreCase("new")) {
			WebExch2kScheduleParseHelper sche = new WebExch2kScheduleParseHelper();
			sche.setStartDate(date);
			sche.setEndDate(date);
			env.put("eEditSchedule",sche);
			env.put("eScheStyle","NewSche");
			request.setAttribute("editSchedule",sche);
			return mapping.findForward("NewSche");
		}
		if (fc.equalsIgnoreCase("edit")) {
			WebExch2kScheduleParseHelper sche = (WebExch2kScheduleParseHelper)env.get("eschedule");
			env.put("eEditSchedule",sche);
			request.setAttribute("editSchedule",sche);
			env.put("eScheStyle","ScheEdit");
			return mapping.findForward("ScheEdit");
		}
		if (fc.equalsIgnoreCase("List")) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.schedate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			    DateControler dc = new DateControler(date);
			    String dateStr = dc.getDateStr();
			    env.put("date", dateStr);
			}
			setList(env,request,getAllSchedules(env,date));
			return mapping.findForward("ScheList");
		}
		if (fc.equalsIgnoreCase("view")) {
			WebExch2kScheduleParseHelper sche = (WebExch2kScheduleParseHelper)env.get("eschedule");
			if (sche != null) {
//				Integer cacheIdx = (Integer)env.get("cacheIdx");
//				Integer idx = (Integer)env.get("midx");
//				if (idx.equals(cacheIdx)) {
//					scheduleAttrsSet(request, sche);
//					return mapping.findForward("ScheDetail");
//				}
			}
			sche = getSchedule(env);
			scheduleAttrsSet(env,request, sche);
			int cp = ((Integer)env.get("cp")).intValue();
			if (cp>0) {
				return mapping.findForward("ScheDetail2");
			}
			return mapping.findForward("ScheDetail");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("ScheDelCheck");
		}
		if (fc.equalsIgnoreCase("del")) {
			if (checkDeleteIgnore(env)) {
				WebScheduleParseHelper sche = (WebScheduleParseHelper)env.get("eschedule");
				scheduleAttrsSet(env,request, sche);
				int cp = ((Integer)env.get("cp")).intValue();
				if (cp>0) {
					return mapping.findForward("ScheDetail2");
				}
				return mapping.findForward("ScheDetail");
			}
			deleteSchedule(env);
			return mapping.findForward("eMenu");
		}
		return mapping.findForward("error");
	}

	private boolean checkDeleteIgnore(CommandEnvSet env)
	{
		String submit = env.getString("submit");
		if ("폜".equals(submit)) return false;
		return true;
	}
	
	private ActionForward processCreateSchedule(CommandEnvSet env,DynaActionForm form, HttpServletRequest request,ActionMapping mapping, String fc) throws Exception
	{
		WebExch2kScheduleParseHelper newSche = (WebExch2kScheduleParseHelper)env.get("eEditSchedule");
		boolean rc = false;
		if (fc.equalsIgnoreCase("restore")) {
			request.setAttribute("editSchedule",newSche);
			String mode = env.getString("eScheStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("TOScheAdd")) {
			String addressType = env.getString("at");
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newSche.getTOCollection();
			MailAddress to = new MailAddress(addr.getDisplayName(),addr.getEmail());
			c.add(to);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newSche.setTO(a);
			request.setAttribute("editSchedule",newSche);
			String mode = env.getString("eScheStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("CCScheAdd")) {
			String addressType = env.getString("at");
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newSche.getCCCollection();
			MailAddress cc = new MailAddress(addr.getDisplayName(),addr.getEmail());
			c.add(cc);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newSche.setCC(a);
			request.setAttribute("editSchedule",newSche);
			String mode = env.getString("eScheStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("searchTO")) {
			String returnPath = "TOScheList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("searchCC")) {
			String returnPath = "CCScheList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("TOScheInit")) {
			return mapping.findForward("TOSche");
		}
		if (fc.equalsIgnoreCase("CCScheInit")) {
			return mapping.findForward("CCSche");
		}
		if (fc.equalsIgnoreCase("new")||fc.equalsIgnoreCase("edit")) {
			boolean timeCheck;
			timeCheck = checkScheduleInput(form,newSche,request);
			if(timeCheck) { rc = processScheduleInput(form,newSche); }
			
			
			String submit = env.getString("submit");
			if (submit.indexOf("ۑ")>=0) {
				if (timeCheck==false){
					request.setAttribute("editSchedule",newSche); // restore input form
					if (fc.equalsIgnoreCase("new")) {
						return mapping.findForward("inputErrorNew");
					}
					else {
						return mapping.findForward("inputErrorEdit");
					}
				}
				if (rc==false) {
					return mapping.findForward("error");
				}
				//newSche.escapeTags();

				return saveSchedule(env,form,mapping,newSche);
			}
			else if (submit.indexOf("[K{")>=0) {
				return mapping.findForward("TOSche");
			}
			else if (submit.indexOf("[C")>=0) {
				return mapping.findForward("CCSche");
			}
			
			
			return mapping.findForward("error");
		}
		return mapping.findForward("error");
	}
	
	private ActionForward saveSchedule(CommandEnvSet env,DynaActionForm form,ActionMapping mapping,WebExch2kScheduleParseHelper newSche) throws Exception
	{
		String fromString=null;
		if (fromString==null) {
			fromString="ConnectONE";
		}

//		try {
				ctrl.saveSchedule(env.getString("u"),env.getString("p"),newSche.getScheduleDTO());
//		}
//		catch(Exception e) {
//			Log.error("",e);
//			 return mapping.findForward("authError");
//		}
		return mapping.findForward("ScheSaved");
	}
		
	/**
	 * @param mapping
	 * @param request
	 * @return
	 * @throws Exception
	 */
	private ActionForward processTask(CommandEnvSet env,DynaActionForm form,ActionMapping mapping, HttpServletRequest request,String fc) throws Exception
	{
		if (fc.equalsIgnoreCase("Save")) {
			WebTaskParseHelper task = (WebTaskParseHelper)env.get("etask");
			task.setBody(form.getString("body"));
			task.setNew(false);      //Task is always editted
			//task.escapeTags();
			ctrl.saveTask(env.getString("u"),env.getString("p"),task);
			taskAttrsSet(env,request, task);
			return mapping.findForward("TaskSaved");
		}
		else if (fc.equalsIgnoreCase("List")) {
			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(), CMD_TASK,null,cp);

			setList(env,request,getAllTasks(env));
			return mapping.findForward("Task");
		}
		else if (fc.equalsIgnoreCase("view")) {
			WebTaskParseHelper task = (WebTaskParseHelper)env.get("etask");
			task = getTask(env);
			taskAttrsSet(env,request, task);
			return mapping.findForward("TaskDetail");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("TaskDelCheck");
		}
		if (fc.equalsIgnoreCase("del")) {
			if (checkDeleteIgnore(env)) {
				WebTaskParseHelper task = (WebTaskParseHelper)env.get("etask");
				taskAttrsSet(env,request, task);
				return mapping.findForward("TaskDetail");
			}
			deleteTask(env);
			return mapping.findForward("eMenu");
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @param request
	 * @return
	 * @throws Exception
	 */
	private ActionForward processMemo(CommandEnvSet env,DynaActionForm form,ActionMapping mapping, HttpServletRequest request ,String fc) throws Exception
	{
		if (fc.equalsIgnoreCase("Save")) {
			WebMemoParseHelper memo = (WebMemoParseHelper)env.get("ememo");
			memo.setBody(form.getString("body"));
			memo.setNew(false);      //Memo is always editted
			//memo.escapeTags();
			ctrl.saveMemo(env.getString("u"),env.getString("p"),memo);
			memoAttrsSet(env,request, memo);
			return mapping.findForward("MemoSaved");
		}
		else if (fc.equalsIgnoreCase("List")) {
			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(), CMD_MEMO,null,cp);

			setList(env,request,getAllMemos(env));
			return mapping.findForward("Memo");
		}
		else if (fc.equalsIgnoreCase("view")) {
			WebMemoParseHelper memo = (WebMemoParseHelper)env.get("ememo");
			if (memo != null) {
			}
			memo = getMemo(env);
			memoAttrsSet(env,request, memo);
			return mapping.findForward("MemoDetail");
			
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MemoDelCheck");
		}
		if (fc.equalsIgnoreCase("del")) {
			if (checkDeleteIgnore(env)) {
				WebMemoParseHelper memo = (WebMemoParseHelper)env.get("ememo");
				memoAttrsSet(env,request, memo);
				return mapping.findForward("MemoDetail");
			}
			deleteMemo(env);
			return mapping.findForward("eMenu");
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward prepareNewMail(CommandEnvSet env,HttpServletRequest request,ActionMapping mapping,String fc)
	{
		env.put("cacheIdx",null);
		if (fc.equalsIgnoreCase("New") ) {
			WebMailParseHelper newMail = WebMailParseHelper.getNewMail();
			env.put("eSendMail",newMail);
			env.put("eMailStyle","NewMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("NewMail");
		}
		WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
		if (fc.equalsIgnoreCase("fw")) {
			WebMailParseHelper newMail = WebMailParseHelper.getForwardMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","FwMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("FwMail");
		}
		if (fc.equalsIgnoreCase("re")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			env.put("replyType",fc);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("reall")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyAllMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			env.put("replyType",fc);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("ret")) {
			WebMailParseHelper newMail = (WebMailParseHelper)env.get("eSendMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward((String)env.get("eMailStyle"));
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processMail(CommandEnvSet env,DynaActionForm form, HttpServletRequest request,ActionMapping mapping, String fc,String forward) throws Exception
	{
		WebMailParseHelper newMail = (WebMailParseHelper)env.get("eSendMail");
		boolean rc = false;
		if (fc.equalsIgnoreCase("restore")) {
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("eMailStyle");
			request.setAttribute("replyType",env.getString("replyType"));
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("TOAddrAdd")) {
			String addressType = env.getString("at");
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getTOCollection();
			MailAddress to = new MailAddress(addr.getEmail());
			c.add(to);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newMail.setTO(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("eMailStyle");
			request.setAttribute("replyType",env.getString("replyType"));
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("CCAddrAdd")) {
			String addressType = env.getString("at");
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getCCCollection();
			MailAddress cc = new MailAddress(addr.getEmail());
			c.add(cc);
			MailAddress[] a = new MailAddress[1];
			a = c.toArray(a);
			newMail.setCC(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("eMailStyle");
			request.setAttribute("replyType",env.getString("replyType"));
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("BCCAddrAdd")) {
			String addressType = env.getString("at");
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getBCCCollection();
			MailAddress bcc = new MailAddress(addr.getEmail());
			c.add(bcc);
			MailAddress[] a = new MailAddress[1];
			a = c.toArray(a);
			newMail.setBCC(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("eMailStyle");
			request.setAttribute("replyType",env.getString("replyType"));
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("searchTO")) {
			String returnPath = "TOAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("searchCC")) {
			String returnPath = "CCAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("searchBCC")) {
			String returnPath = "BCCAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("TOAddrInit")) {
			return mapping.findForward("TOAddr");
		}
		if (fc.equalsIgnoreCase("CCAddrInit")) {
			return mapping.findForward("CCAddr");
		}
		if (fc.equalsIgnoreCase("BCCAddrInit")) {
			return mapping.findForward("BCCAddr");
		}
		if (fc.equalsIgnoreCase("new")||fc.equalsIgnoreCase("re")||fc.equalsIgnoreCase("reall")||fc.equalsIgnoreCase("fw")) {
			rc = processMailInput(form,newMail);
			String submit = form.getString("submit");
Log.debug("submit="+submit);
			if (submit.indexOf("M")>=0) {
				if (rc==false) {
					ActionMessages amsgError = new ActionMessages();
					ActionMessage msg = new ActionMessage("errors.email.void");
					amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
					saveErrors(request, amsgError);
					request.setAttribute("sendMail",newMail);
					if (fc.equalsIgnoreCase("new")){
						return mapping.findForward("NewMail");
					}else if (fc.equalsIgnoreCase("re")||fc.equalsIgnoreCase("reall")){
						return mapping.findForward("ReplyMail");
					}else if (fc.equalsIgnoreCase("fw")){
						return mapping.findForward("FwMail");
					}
					return mapping.findForward("error");
				}

				ActionMessages amsgError = new ActionMessages();
				if(!checkAddressFormat(makeArray(form.getString("TO")))){
					ActionMessage msg = new ActionMessage("errors.email.invalid","");
					amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
				}
				if(!checkAddressFormat(makeArray(form.getString("CC")))){
					ActionMessage msg = new ActionMessage("errors.email.invalid","CC");
					amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
				}
				if(!checkAddressFormat(makeArray(form.getString("BCC")))){
					ActionMessage msg = new ActionMessage("errors.email.invalid","BCC");
					amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
				}
				if(!amsgError.isEmpty()){
					saveErrors(request, amsgError);
					request.setAttribute("sendMail",newMail);
					if (fc.equalsIgnoreCase("new")){
						return mapping.findForward("NewMail");
					}else if (fc.equalsIgnoreCase("re")){
						return mapping.findForward("ReplyMail");
					}else if (fc.equalsIgnoreCase("reall")){
						return mapping.findForward("ReplyMail");
					}else if (fc.equalsIgnoreCase("fw")){
						return mapping.findForward("FwMail");
					}
					return mapping.findForward("error");
				}
				return sendMail(env,form,mapping,newMail,forward);
			}
			else if (submit.indexOf("[]")>=0) {
				return mapping.findForward("TOAddr");
			}
			else if (submit.indexOf("[CC]")>=0) {
				return mapping.findForward("CCAddr");
			}
			else if (submit.indexOf("[BCC]")>=0) {
				return mapping.findForward("BCCAddr");
			}
			return mapping.findForward("error");
		}
		return mapping.findForward("error");
	}

	/**
	 * @param request
	 * @param mapping
	 * @param returnPath
	 * @return
	 * @throws Exception
	 */
	private ActionForward searchMailAddress(CommandEnvSet env,HttpServletRequest request, ActionMapping mapping, String returnPath) throws Exception
	{
		env.put("cp", new Integer(0));
		String addressType = env.getString("at");
		String name = env.getString("name");
		if (addressType.equalsIgnoreCase("g")) {
			setList(env,request,searchActiveDirectory(env,name));
		}
		else {
			setList(env,request,searchAddressBook(env,name));
		}
		return mapping.findForward(returnPath);
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward sendMail(CommandEnvSet env,DynaActionForm form,ActionMapping mapping,WebMailParseHelper newMail,String forward) throws Exception
	{
		String fromString=null;
		if (fromString==null) {
			fromString="ConnectONE";
		}
Log.debug("from:"+fromString);
		newMail.setFrom(fromString);
		String body = newMail.getBody();
		String quatation = form.getString("q");
		if (quatation!=null) {
			if (quatation.equals("y")) {
				body = body + newMail.getOriginalBody();
			}
		}
		newMail.setBody(body);
		
		try {
				ctrl.sendMail(env.getString("u"),env.getString("p"),newMail.getMail());
		}
		catch(Exception e) {
			String userid=env.getString("u");
			Log.info("user "+userid+" Access Denied", e);
			return mapping.findForward("authError");
		}
		Log.debug("subject:"+newMail.getSubject());
		return mapping.findForward(forward);
	}

	/**
	 * @param form
	 */
	private boolean processMailInput(DynaActionForm form,WebMailParseHelper newMail)
	{
		boolean rc = true;
		String[] toArray = makeArray(form.getString("TO"));
		if (toArray!=null)Log.debug("to[]:"+Arrays.asList(toArray));
			
		newMail.setTO(toArray);

		String[] ccArray = makeArray(form.getString("CC"));
		if (ccArray!=null)Log.debug("cc[]:"+Arrays.asList(ccArray));

		newMail.setCC(ccArray);
			
		String bcc = form.getString("BCC").trim();
		if (bcc.endsWith(",")) {
			bcc = bcc.substring(0,bcc.length()-1);
		}
		String[] bccArray = makeArray(bcc);
		if (bccArray!=null)Log.debug("bcc[]:"+Arrays.asList(bccArray));

		newMail.setBCC(bccArray);

		String subject = form.getString("subject");
		if (subject.length()>256) subject = subject.substring(0, 256);
		
		newMail.setSubject(subject);
		String body=form.getString("body");
		newMail.setBody(body);
		
		if ((toArray==null || toArray.length==0) && (ccArray==null || ccArray.length==0) && (bccArray==null || bccArray.length==0)) {
			rc = false;
		}
		return rc;
	}
	
	private boolean checkScheduleInput(DynaActionForm form, WebExch2kScheduleParseHelper newSche, HttpServletRequest req){
		boolean pass = true;
		newSche.setSubject(form.getString("subject"));
		newSche.setBody(form.getString("body"));
		newSche.setLocation(form.getString("location"));

		ActionMessages errorMsgs = new ActionMessages();
		
		String sd = form.getString("startDate");
		String sh = form.getString("startHour");
		String ed = form.getString("endDate");
		String eh = form.getString("endHour");
		
		/* check input form */
		Pattern datePattern = Pattern.compile("^[0-9]{8}$");
		Pattern hourPattern = Pattern.compile("^[0-9]{4}$");
		Matcher startDateMatcher = datePattern.matcher(sd);
		Matcher endDateMatcher = datePattern.matcher(ed);
		Matcher startHourMatcher = hourPattern.matcher(sh);
		Matcher endHourMatcher = hourPattern.matcher(eh);
		if(!startDateMatcher.matches()){
			ActionMessage emsg = new ActionMessage("errors.invalid","Jn" );
			errorMsgs.add(ActionMessages.GLOBAL_MESSAGE,emsg);
			pass = false;
		}
		else if (!endDateMatcher.matches()){
			ActionMessage emsg = new ActionMessage("errors.invalid","I" );
			errorMsgs.add(ActionMessages.GLOBAL_MESSAGE,emsg);
			pass = false;
		} 
		else if(!startHourMatcher.matches()){
			ActionMessage emsg = new ActionMessage("errors.invalid","Jn" );
			errorMsgs.add(ActionMessages.GLOBAL_MESSAGE,emsg);
			pass = false;
		}
		else if (!endHourMatcher.matches()){
			ActionMessage emsg = new ActionMessage("errors.invalid","I" );
			errorMsgs.add(ActionMessages.GLOBAL_MESSAGE,emsg);
			pass = false;
		} 
		/* Check whether the end date is later than the start date. */
		else if (Long.parseLong(ed + eh) < Long.parseLong(sd + sh) ){
			ActionMessage emsg = new ActionMessage("errors.schedule.invalidTime","" );
			errorMsgs.add(ActionMessages.GLOBAL_MESSAGE,emsg);
			pass = false;
		}
				
		this.saveErrors(req, errorMsgs);
		
		return pass;
	}

	private boolean processScheduleInput(DynaActionForm form,WebExch2kScheduleParseHelper newSche)
	{
		boolean rc = true;
		newSche.setSubject(form.getString("subject"));
		newSche.setBody(form.getString("body"));
		newSche.setLocation(form.getString("location"));


		
		String sd = form.getString("startDate");
		String sh = form.getString("startHour");
		String ed = form.getString("endDate");
		String eh = form.getString("endHour");
		
		String startDateStr;
		String endDateStr;
		if (sd.length() == 4) {
			startDateStr = Integer.toString(Calendar.getInstance().get(Calendar.YEAR)) + sd + sh;
		} else { // sd.lendth() == 8
			startDateStr = sd + sh;
		}
		if (ed.length() == 4) {
			endDateStr = Integer.toString(Calendar.getInstance().get(Calendar.YEAR)) + ed + eh;
		} else {
			endDateStr = ed + eh;
		}

		Date startDate = DateControler.getDateFromStr(startDateStr);
		newSche.setStartDate(startDate);
		Date endDate = DateControler.getDateFromStr(endDateStr);
		newSche.setEndDate(endDate);
		return rc;
	}

	private ActionForward processFolderMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		HttpSession session=request.getSession(true);
		if (fc.equalsIgnoreCase(FC_FLIST)) {
			env.put("cacheIdx",null);
			StrutsArrayList list = (StrutsArrayList)session.getAttribute("eFolderList");
			if (list != null) {
				//cache
				request.setAttribute("list",list);
			}else {
				setList(env,request,getMailFolderList(env));
			}
			return mapping.findForward("FolderList");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.maildate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			    DateControler dc = new DateControler(date);
			    String dateStr = dc.getDateStr();
			    env.put("date", dateStr);
			}
			env.put("cacheIdx",null);
			Integer idx = (Integer)env.get("fidx");
			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(),CMD_FOLDER_MAIL,idx,cp);

			setList(env,request,getMailList(env,session,date));
			request.setAttribute("name",env.get("folderName"));
			return mapping.findForward("MailList");
		}
		if (fc.equalsIgnoreCase(FC_ATT)) {
			DhkWebAttachmentParseHelper att = (DhkWebAttachmentParseHelper)env.get("attach");
			if (att != null) {
				mailAttachmentSet(env, request, att);
				return mapping.findForward("Attachment");
			}
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail == null) {
				mail = getMail(env);
			}
			Integer aidx = (Integer)env.get("aidx");
			IMailDTO dto = mail.getMail();
			if (dto.getNumberOfAttachments()>0) {
				att = new DhkWebAttachmentParseHelper(dto.getAttachment(aidx.intValue()));
				att.setBodyLength(mail.getBodyLength());
				mailAttachmentSet(env, request, att);
			}
			return mapping.findForward("Attachment");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail != null) {
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("Mail2");
					}
					return mapping.findForward("FolderMail");
				}
			}
			mail = getMail(env);
			mailAttrsSet(env,request, mail);
			return mapping.findForward("FolderMail");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
			request.setAttribute("mail",env.get("email"));
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
				mailAttrsSet(env,request, mail);
				int cp = ((Integer)env.get("cp")).intValue();
				if (cp>0) {
					return mapping.findForward("Mail2");
				}
				return mapping.findForward("FolderMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			deleteMail(env);
			env.put("date",null);
			return mapping.findForward("eMenu");
		}
		if (fc.equalsIgnoreCase(FC_RE)) {
			return prepareNewMail(env,request,mapping,fc);
		}
		if (fc.equalsIgnoreCase(FC_REALL)) {
			return prepareNewMail(env,request,mapping,fc);
		}
		if (fc.equalsIgnoreCase(FC_FW)) {
			return prepareNewMail(env,request,mapping,fc);
		}
		return mapping.findForward("error");
	}

	private void mailAttrsSet(CommandEnvSet env,HttpServletRequest request, WebMailParseHelper mail)
	{
		Integer currentPage = (Integer)env.get("cp");
		mail.setCurrentPage(currentPage.intValue());
		request.setAttribute("mail",mail);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("attach",null);
		env.put("email",mail);
		env.put("cacheIdx",Idx);
		
	}
	private void mailAttachmentSet(CommandEnvSet env,HttpServletRequest request, DhkWebAttachmentParseHelper att)
	{
		Integer currentPage = (Integer)env.get("cp");
		att.setCurrentPage(currentPage.intValue());
		ServletContext ctx = getServlet().getServletContext();
		String path = ctx.getRealPath("");
		att.setAbsolutePath(path);
		env.put("attach",att);
		request.setAttribute("attach",att);

	}

	private void addrAttrsSet(CommandEnvSet env,HttpServletRequest request, WebAddressParseHelper addr)
	{
		request.setAttribute("address",addr);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("eaddress",addr);
		env.put("cacheIdx",Idx);
	}

	private void memoAttrsSet(CommandEnvSet env,HttpServletRequest request, WebMemoParseHelper memo)
	{
		request.setAttribute("memo",memo);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("ememo",memo);
		env.put("cacheIdx",Idx);
	}

	private void taskAttrsSet(CommandEnvSet env,HttpServletRequest request, WebTaskParseHelper task)
	{
		request.setAttribute("task",task);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("etask",task);
		env.put("cacheIdx",Idx);
	}

	private void scheduleAttrsSet(CommandEnvSet env,HttpServletRequest request, WebScheduleParseHelper sche)
	{
Log.debug("scheduleAttrsSet:schedule="+sche);
Log.debug("scheduleAttrsSet:subject="+sche.getSubject());
		Integer currentPage = (Integer)env.get("cp");
		sche.setCurrentPage(currentPage.intValue());
		request.setAttribute("schedule",sche);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("eschedule",sche);
		env.put("cacheIdx",Idx);
	}

	private ActionForward processInboxMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		if (fc.equalsIgnoreCase(FC_ATT)) {
			DhkWebAttachmentParseHelper att = (DhkWebAttachmentParseHelper)env.get("attach");
			if (att != null) {
				mailAttachmentSet(env, request, att);
				return mapping.findForward("Attachment");
			}
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail == null) {
				mail = getMail(env);
			}
			Integer aidx = (Integer)env.get("aidx");
			IMailDTO dto = mail.getMail();
			if (dto.getNumberOfAttachments()>0) {
				att = new DhkWebAttachmentParseHelper(dto.getAttachment(aidx.intValue()));
				att.setBodyLength(mail.getBodyLength());
				mailAttachmentSet(env, request, att);
			}
			return mapping.findForward("Attachment");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail != null) {
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("Mail2");
					}
					return mapping.findForward("InboxMail");
				}
			}
			mail = getMail(env);
			mailAttrsSet(env,request, mail);
			return mapping.findForward("InboxMail");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.maildate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			    DateControler dc = new DateControler(date);
			    String dateStr = dc.getDateStr();
			    env.put("date", dateStr);
			}

			env.put("cacheIdx",null);
			StrutsArrayList list = getAllMails(env,date);
			setList(env,request,list);

			Integer cp = new Integer(list.getCurrentPage());
			setCmdCache(request.getSession(),CMD_INBOX_MAIL,null,cp);

			return mapping.findForward("Inbox");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
			env.put("cacheIdx",null);
			request.setAttribute("mail",env.get("email"));
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
				mailAttrsSet(env,request, mail);
				int cp = ((Integer)env.get("cp")).intValue();
				if (cp>0) {
					return mapping.findForward("Mail2");
				}
				return mapping.findForward("InboxMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			deleteMail(env);
			env.put("date",null);
			return mapping.findForward("eMenu");
		}
		env.put("cacheIdx",null);
		return mapping.findForward("error");
	}
	
	void setList(CommandEnvSet env,HttpServletRequest request,StrutsArrayList list)
	{
		HttpSession session=request.getSession(true);
		Integer cp = (Integer)env.get("cp");
		if (cp != null) {
			list.setCurrentPage(cp.intValue());
		}
		if (list.size()==0) {
			request.setAttribute("list",list);
			return;
		}
		IRecordObject sample = (IRecordObject)list.get(0);
		if (sample instanceof FolderMetadata) {
			session.setAttribute("eFolderList",list);
		}
		else {
			env.put("eList",list.getIdxList());
		}
		request.setAttribute("list",list);
	}
	
	private StrutsArrayList getMailList(CommandEnvSet env,HttpSession session,Date date) throws Exception
	{
		Integer idx = (Integer)env.get("fidx");
		StrutsArrayList flist = (StrutsArrayList)session.getAttribute("eFolderList");
		FolderMetadata folder = (FolderMetadata)flist.get(idx.intValue());
		env.put("folderName",folder.getFolderName());
		IFolderIndex fid = (IFolderIndex)folder.getOid();
		StrutsArrayList rc = ctrl.getMailList(env.getString("u"),env.getString("p"),fid,date);
		int ps = rc.getPageSize();
		IMailParseHelperComparator c = new IMailParseHelperComparator(IMailParseHelperComparator.RECEIVEDDATE,true);
		WebMailParseHelper a[] = new WebMailParseHelper[0];
		a = (WebMailParseHelper[])rc.toArray(a);
		StrutsArrayList list = sortList(ps, c, a);
		for (int i=0; i<list.size();i++) {
			Log.debug("subject:" + ((WebMailParseHelper)list.get(i)).getSubject());
		}
		return list;
	}
	
	private WebMailParseHelper getMail(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		WebMailParseHelper rc = ctrl.getMail(env.getString("u"),env.getString("p"),mid);
		Log.debug("subject:" + rc.getSubject());
		return rc;
	}
	
	private void deleteMail(CommandEnvSet env) throws Exception
	{
		WebMailParseHelper o = (WebMailParseHelper)env.get("email");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}
	
	private void deleteSchedule(CommandEnvSet env) throws Exception
	{
		WebScheduleParseHelper o = (WebScheduleParseHelper)env.get("eschedule");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}
	
	private void deleteMemo(CommandEnvSet env) throws Exception
	{
		WebMemoParseHelper o = (WebMemoParseHelper)env.get("ememo");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}
	
	private void deleteTask(CommandEnvSet env) throws Exception
	{
		WebTaskParseHelper o = (WebTaskParseHelper)env.get("etask");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}
	
	private WebMemoParseHelper getMemo(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getMemo(env.getString("u"),env.getString("p"),mid);
	}
	
	private WebTaskParseHelper getTask(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getTask(env.getString("u"),env.getString("p"),mid);
	}
	
	private WebExch2kScheduleParseHelper getSchedule(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getSchedule(env.getString("u"),env.getString("p"),mid);
	}
	
	private WebExch2kScheduleParseHelper getOtheronesSchedule(CommandEnvSet env,IObjectIndex idToSee) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getOtheronesSchedule(env.getString("u"),env.getString("p"),idToSee,mid);
	}
	
	private StrutsArrayList getAllMails(CommandEnvSet env,Date date) throws Exception
	{
		StrutsArrayList rc = ctrl.getMailList(env.getString("u"),env.getString("p"),null,date);
		int ps = rc.getPageSize();
		IMailParseHelperComparator c = new IMailParseHelperComparator(IMailParseHelperComparator.RECEIVEDDATE,true);
		WebMailParseHelper a[] = new WebMailParseHelper[0];
		a = (WebMailParseHelper[])rc.toArray(a);
		StrutsArrayList list = sortList(ps, c, a);
		for (int i=0; i<list.size();i++) {
			Log.debug("subject:" + ((WebMailParseHelper)list.get(i)).getSubject());
		}
		return list;
	}

	@SuppressWarnings("unchecked")
	private StrutsArrayList sortList(int ps, Comparator c, IRecordObject[] a)
	{
		StrutsArrayList rc;
		Arrays.sort(a,c);
		List<IRecordObject> b = Arrays.asList(a);
		rc = new StrutsArrayList();
		rc.addAll(b);
		rc.setPageSize(ps);
		return rc;
	}
	
	StrutsArrayList getMailFolderList(CommandEnvSet env) throws Exception
	{
		StrutsArrayList list = ctrl.getMailFolderList(env.getString("u"),env.getString("p"));
		return list;
	}
	
	private WebAddressParseHelper getAddressBookItem(CommandEnvSet env,String addressType) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		int mode=0;
		if (addressType.equalsIgnoreCase("g")) {
			mode = Controler.COMMON_ADDRESSBOOK;
		}
		else {
			mode = Controler.PERSONAL_ADDRESSBOOK;
		}
		return ctrl.getAddressBookItem(env.getString("u"),env.getString("p"),mid,mode);
	}

	private StrutsArrayList searchOtheronesScheduleList(CommandEnvSet env,IObjectIndex mid, Date date) throws Exception
	{
		StrutsArrayList rc = ctrl.getOtheronesScheduleList(env.getString("u"),env.getString("p"),mid,date);
		int ps = rc.getPageSize();
		IScheduleDTOComparator c = new IScheduleDTOComparator(IScheduleDTOComparator.STARTDATETIME,false);
		IScheduleDTO a[] = new IScheduleDTO[0];
		a = (IScheduleDTO[])rc.toArray(a);
		return sortList(ps, c, a);
	}
	
	private StrutsArrayList getAllTasks(CommandEnvSet env) throws Exception
	{
		return ctrl.getTaskList(env.getString("u"),env.getString("p"));
	}
	
	private StrutsArrayList getAllSchedules(CommandEnvSet env,Date date) throws Exception
	{
		StrutsArrayList rc = ctrl.getScheduleList(env.getString("u"),env.getString("p"),date);
		int ps = rc.getPageSize();
		IScheduleDTOComparator c = new IScheduleDTOComparator(IScheduleDTOComparator.STARTDATETIME,false);
		IScheduleDTO a[] = new IScheduleDTO[0];
		a = (IScheduleDTO[])rc.toArray(a);
		return sortList(ps, c, a);
	}
	
	private StrutsArrayList getAllMemos(CommandEnvSet env) throws Exception
	{
		return ctrl.getMemoList(env.getString("u"),env.getString("p"));
	}
	
	private StrutsArrayList searchActiveDirectory(CommandEnvSet env,String name) throws Exception
	{
		return ctrl.searchAddress(env.getString("u"),env.getString("p"),name,Controler.COMMON_ADDRESSBOOK);
	}
	
	private StrutsArrayList searchAddressBook(CommandEnvSet env,String name) throws Exception
	{
		return ctrl.searchAddress(env.getString("u"),env.getString("p"),name,Controler.PERSONAL_ADDRESSBOOK);
	}

	private boolean checkAddressFormat(String[] addressArray){
		if(addressArray == null) return true;

		MailTool tool = new MailTool();
		tool.setAllowNullOrBlankMailAddress(false);
		String[] rc = tool.checkMailAddressesString(addressArray);

		return rc.equals(addressArray);
	}
	private void setCmdCache(HttpSession session,String cmd,Integer idx,Integer cp)
	{
		if (session==null) return;
		session.setAttribute("cache_return_cmd", cmd);
		if (idx!=null) {
			session.setAttribute("cache_return_idx", idx);
		}
		if (cp!=null) {
			session.setAttribute("cache_return_cp", cp);
		} else {
			session.setAttribute("cache_return_cp", new Integer(0));
		}
	}

}
