/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.store;

import java.util.*;

import jp.co.connectone.eai.exch2k.dav.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.client.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;

public class Exch2kAddressBookStoreImpl extends EAIExch2kBase implements IAddressBookStore
{
	private static final String DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT="A";
	private IFolderIndex addressBookElement = new Exch2kFolderIndex(DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT);
	public static final IStoreID storeID = new SimpleStoreID(Exch2kAddressBookStoreImpl.class.getName());
	public static final String storeName = "Exchange2K address book store";

	
	public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception
	{
		return super.getServiceInfo(storeID, storeName, serviceData);
	}

	public String getName() throws Exception
	{
		return storeName;
	}

	public IServiceInfo getServiceInfo() throws Exception
	{
		return new Exch2kServiceInfo(storeID,storeName);
	}

	public IStoreID getStoreID() throws Exception
	{
		return storeID;
	}
	private IAddressDTO populateAddressDTO(HashMap<String,?> itemList)
	{
		IAddressDTO l_objIAddressDTO = new BasicAddressDTO();
		l_objIAddressDTO.setTid((String) itemList.get("id"));
		l_objIAddressDTO.setOid(new Exch2kObjectIndex(itemList.get("href")));
		l_objIAddressDTO.setFirstName((String) itemList.get("givenName"));
		l_objIAddressDTO.setFamilyName((String) itemList.get("sn"));

		String displayName = (String) itemList.get("fileas");
		if (displayName==null) {
			displayName = (String) itemList.get("displayname");// in case do not have fileas field.
		}
Log.debug("displayName=[" + displayName + "]");
		l_objIAddressDTO.setDisplayName(displayName);
		String email = null;
		Vector<String> v = new Vector<String>();
		email = (String) itemList.get("email1");
		if (email != null)
			v.add(email);
		email = (String) itemList.get("email2");
		if (email != null)
			v.add(email);
		email = (String) itemList.get("email3");
		if (email != null)
			v.add(email);

		email = (String) itemList.get("email1");
		int l = v.size();
		for (int i = 0; i < l; i++) {
			String tmp = (String) v.get(i);
			if (tmp.startsWith("SMTP:")) {
				email = tmp.substring(5);
				break;
			}
		}

		l_objIAddressDTO.setEmail(email);
		l_objIAddressDTO.setCompanyPhone((String) itemList.get("telephoneNumber"));
		l_objIAddressDTO.setHomePhone((String) itemList.get("homePhone"));
		l_objIAddressDTO.setMobilePhone((String) itemList.get("mobile"));
		l_objIAddressDTO.setCompanyName((String) itemList.get("o"));
		l_objIAddressDTO.setCompanyAddress( (String) itemList.get("workaddress"));

		return l_objIAddressDTO;
	}

	private IAddressDTO populateAddressDTO2(HashMap<String,String> itemList)
	{
		IAddressDTO l_objIAddressDTO = new BasicAddressDTO();
		String tid =  itemList.get("userPrincipalName");
		if (tid == null)
			tid = "";
		l_objIAddressDTO.setTid(tid.replaceAll("@", "."));
		l_objIAddressDTO.setOid(new Exch2kObjectIndex( itemList.get("sAMAccountName")));
		l_objIAddressDTO.setFirstName( itemList.get("givenName"));
		l_objIAddressDTO.setFamilyName( itemList.get("sn"));
		l_objIAddressDTO.setEmail( itemList.get("mail"));
		l_objIAddressDTO.setCompanyPhone( itemList.get("telephoneNumber"));
		l_objIAddressDTO.setHomePhone( itemList.get("homePhone"));
		l_objIAddressDTO.setMobilePhone( itemList.get("mobile"));
		l_objIAddressDTO.setCompanyName( itemList.get("company"));
		l_objIAddressDTO.setDisplayName( itemList.get("displayName"));
		Log.debug("displayName=" +  itemList.get("displayName"));

		String st =  itemList.get("st");
		if (st == null)
			st = "";
		String l =  itemList.get("l");
		if (l == null)
			l = "";
		String streetAddress =  itemList.get("streetAddress");
		if (streetAddress == null)
			streetAddress = "";
		l_objIAddressDTO.setCompanyAddress(st + l + streetAddress);

		return l_objIAddressDTO;
	}

	public IObjectIndex createNewAddressBookItem(IAccountData acc,ISearchDestination dest, IAddressDTO IAddressDTO) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		throw new HandleException("not yet implemented");
	}

	public IAddressDTO[] getAddressBookItems(IAccountData acc, ISearchDestination dest) throws IncorrectData, StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);
		if (dest.getDatabase() != null) {
			throw new HandleException("get all datas from ActiveDirectory is not supported.");
		}
		Vector<HashMap<String,Object>> col = super.getList(getDefaultUserAddressBook(), getDefaultFieldList());
		int len = col.size();
		IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[len];
		for (int i = 0; i < len; i++) {
			l_IAddressDTOArray[i] = populateAddressDTO(col.elementAt(i));
		}

		return l_IAddressDTOArray;

	}

	public IAddressDTO getAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		IAddressDTO l_objIAddressDTO = null;

Log.debug("getAddressBookItem::oid=" + oid);

		setAccountData((PasswordBasedAccountDataImpl)acc);
		if (dest.getDatabase() != null) {
			SearchConditionCollection conds = new SearchConditionCollection();
			AddressBookSearchCondition cond = new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME,oid.getIndex().toString());
			conds.add(cond);
			List<HashMap<String, String>> col = searchUserFromActiveDirectory(conds);
			if (col.size()==0) {
				throw new DataNotFound("account that has sAMAAccountName="+oid.getIndex().toString()+" not found.");
			}
			l_objIAddressDTO = populateAddressDTO2(col.get(0));
		}
		else {
			HashMap<String,Object> addr = super.getProps(oid.getIndex().toString(),getDefaultFieldList());

			l_objIAddressDTO = populateAddressDTO(addr);
		}

		return l_objIAddressDTO;
	}

	public IObjectIndex updateAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO IAddressDTOObj) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, UpdateFailed, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("not yet implemented");

	}
	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.pim.IAddressBookStore#deleteAddressBookItem(jp.co.connectone.user.IAccountData, java.lang.String, jp.co.connectone.store.IObjectIndex)
	 */
	public void deleteAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("not yet implemented");
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.mail.IEAIAddressBookStore#searchAddressBook(java.lang.String,
	 *      java.lang.String, java.lang.String, java.lang.String,
	 *      jp.co.connectone.store.ISearchFormula)
	 */
	public IAddressDTO[] searchAddressBook(IAccountData acc, ISearchFormula conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException
	{
		
		if (conds.getDest().getDatabase() != null) {
			Log.debug("search from active directory");
			return searchActiveDirectory(acc, conds.getSearchConditions());
		}
		else if (AddressBookFolderNames.DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT.equalsIgnoreCase(conds.getDest().getFolder().getIndex().toString())) {
			Log.debug("search from personal address book");
			return searchPersonalAddressbook(acc, AddressBookFolderNames.DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT, conds.getSearchConditions());
		}
		else {
			throw new HandleException("Illegal strDBName");
		}
	}

	private IAddressDTO[] searchActiveDirectory(IAccountData acc, SearchConditionCollection conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);

		List<HashMap<String,String>> col = searchUserFromActiveDirectory(conds);
		int len = col.size();
		Log.debug("results(searchUserFromActiveDirectory):" + len);
		IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[0];
		ArrayList<IAddressDTO> ar = new ArrayList<IAddressDTO>();
		for (int i = 0; i < len; i++) {
			IAddressDTO dto = null;
			try {
				dto = populateAddressDTO2(col.get(i));
			}
			catch (Exception e) {
				Log.error("IAddressDTO populate error:Igunore address data no "+i,e);
				continue;
			}
			ar.add(dto);
		}
		l_IAddressDTOArray = ar.toArray(l_IAddressDTOArray);

		return l_IAddressDTOArray;
	}

	private IAddressDTO[] searchPersonalAddressbook(IAccountData acc, String strDBName, SearchConditionCollection conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);
		Vector<HashMap<String,String>> col = super.search(strDBName, getDefaultFieldList(), conds);
		int len = col.size();
		IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[0];
		ArrayList<IAddressDTO> ar = new ArrayList<IAddressDTO>();
		for (int i = 0; i < len; i++) {
			IAddressDTO dto = null;
			try {
				dto = populateAddressDTO(col.elementAt(i));
			}
			catch (Exception e) {
				Log.error("IAddressDTO populate error:Igunore address data no "+i,e);
				continue;
			}
			ar.add(dto);
		}
		l_IAddressDTOArray = ar.toArray(l_IAddressDTOArray);

		return l_IAddressDTOArray;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.eai.exch2k.logic.EAIExch2kBase#convertCondition(jp.co.connectone.store.SearchCondition)
	 */
	protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException
	{
		ISearchType cond = src.getType();
		DavSearchType type = DavSearchType.TYPE_STRING;
		String name = null;
		if (cond == AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME) {
			name = "urn:schemas:contacts:fileas";
		}
		else if (cond == AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME) {
			name = "urn:schemas:contacts:givenName";
		}
		else if (cond == AddressBookSearchCondition.CONDITION.TYPE_LASTNAME) {
			name = "urn:schemas:contacts:sn";
		}
		else {
			throw new HandleException("Condition type not supported");
		}
		DavSearchCondition dst = new DavSearchCondition(name, type, src.getValue(), DavSearchOperator.OP_FORWARD_LIKE);
		return dst;
	}

	protected static final Vector<String> fList;
	static {
		fList = new Vector<String>();
		fList.add("DAV:id");
		fList.add("DAV:href");
		fList.add("DAV:displayname");
		fList.add("urn:schemas:httpmail:subject");
		fList.add("urn:schemas:contacts:fileas");
		fList.add("urn:schemas:contacts:account");
		fList.add("urn:schemas:contacts:sn");
		fList.add("urn:schemas:contacts:givenName");
		fList.add("urn:schemas:contacts:email1");
		fList.add("urn:schemas:contacts:email2");
		fList.add("urn:schemas:contacts:email3");
		fList.add("urn:schemas:contacts:telephoneNumber");
		fList.add("urn:schemas:contacts:homePhone");
		fList.add("urn:schemas:contacts:mobile");
		fList.add("urn:schemas:contacts:o");
		fList.add("urn:schemas:contacts:workaddress");
	}

	protected static Vector<String> getDefaultFieldList()
	{
		return fList;
	}

	protected IFolderIndex getDefaultUserAddressBook()
	{
		return new Exch2kFolderIndex("A");
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#delete(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String, jp.co.connectone.store.IObjectIndex)
	 */
	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		deleteAddressBookItem(acc,dest,oid);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#getAllDatas(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String)
	 */
	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception
	{
		return getAddressBookItems(acc,dest);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#getFolderList(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String)
	 */
	public FolderMetadata[] getFolderList(IAccountData arg0, ISearchDestination dest) throws Exception
	{
		throw new UnsupportedOperationException("get folder list on NotesAddressBook not supported.");
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#read(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String, jp.co.connectone.store.IObjectIndex)
	 */
	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		return getAddressBookItem(acc,dest,oid);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#search(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String, jp.co.connectone.store.ISearchFormula)
	 */
	public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception
	{
		return searchAddressBook(acc,col);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#searchByDate(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String, java.util.Date)
	 */
	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date searchDate) throws Exception
	{
		throw new UnsupportedOperationException("searchByDate on NotesAddressBook not supported.");
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#write(jp.co.connectone.user.IAccountData, java.lang.String, java.lang.String, jp.co.connectone.store.IRecordObject)
	 */
	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject address) throws Exception
	{
		IObjectIndex rc = null;
		if (address.isNew()) {
			rc = createNewAddressBookItem(acc,dest,(IAddressDTO)address);
		}
		else {
			rc = updateAddressBookItem(acc,dest,(IAddressDTO)address);
		}
		return rc;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#getPresetDestination(int)
	 */
	public ISearchDestination getPresetDestination(IAccountData acc,int type) throws IncorrectData, HandleException
	{
		super.setAccountData((PasswordBasedAccountDataImpl)acc);
		IFolderIndex folder = null;
		IDatabaseIndex db = null;
		switch (type) {
		case IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER:
			folder = (IFolderIndex)populateFolder(addressBookElement).getOid();
			break;
		case IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK:
			db= (IDatabaseIndex)populateADDatabase().getOid();
			break;
		default:
			throw new IncorrectData("illegal folderType");
		}
		
		return (ISearchDestination)new BasicSearchDestination(db,folder);
	}
	
	public DatabaseMetadata populateADDatabase()
	{
		DatabaseMetadata db = new DatabaseMetadata();
		db.setServerName(super.getAdAddress());
		IDatabaseIndex oid = new Exch2kDatabaseIndex("connector_exch2k:ActiveDirectory."+super.getAdAddress());
		db.setOid(oid);
		HashMap<String,Object> h = db.getFieldSet();
		h.put("oid",oid);
		
		return db;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.eai.exch2k.store.EAIExch2kBase#getElmentName()
	 */
	protected String getElmentName()
	{
		return DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT;
	}
}
