import jp.co.connectone.eai.exch2k.store.*;
import jp.co.connectone.eai.exch2k.user.Exch2kAccountData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SearchFormulaBaseImpl;
import jp.co.connectone.store.client.ScheduleSearchCondition;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
import java.util.*;
import java.text.*;
/**
 * @author amanot
 *
 */
public class TestExch2kScheduleImpl extends TestCase {
	private Exch2kScheduleStoreImpl scheduleStore;
	private PasswordBasedAccountDataImpl acc;
	private Exch2kServiceInfo si;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		scheduleStore = new Exch2kScheduleStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		si = (Exch2kServiceInfo)scheduleStore.getServiceInfo();
		si.setServerAddress("172.16.3.1");
		acc = new Exch2kAccountData(uid,si);
		acc.setUserID("amanot");
		acc.setPassword("********");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		scheduleStore = null;
	}
	
	public void testGetSchedulesByDate() throws Exception
	{
		assertNotNull(scheduleStore);
		Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-04-12 00:00:00");
		Exch2kScheduleDTO[] s = (Exch2kScheduleDTO[])scheduleStore.getSchedulesByDate(acc,date);
		assertNotNull(s);
		for (int i=0;i<s.length;i++) {
			dumpDTO(s[i]);
			Log.debug("sensitivity="+s[i].getFieldSet().get("sensitivity"));
		}
	}
	
	public void testSearch() throws Exception
	{
		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date =sdf.parse("2010-04-12 10:00:00");
		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,new BasicObjectIndex("test"));
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE,date);
		conds.add(cond);
		ISearchDestination dest = scheduleStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		Exch2kScheduleDTO[] scheList = (Exch2kScheduleDTO[])scheduleStore.searchSchedules(acc,formula);
		assertNotNull(scheList);
		for (int i=0;i<scheList.length;i++) {
			dumpDTO(scheList[i]);
		}
		
	}
	
	public void testCreateNewSchedule() throws Exception
	{
		assertNotNull(scheduleStore);
		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date =sdf.parse("2010-04-12 10:00:00");
		Date date2 = sdf.parse("2010-04-12 13:00:00");
		Exch2kScheduleDTO schedule = new Exch2kScheduleDTO();
		schedule.setStartDate(date);
		schedule.setEndDate(date2);
		schedule.setSubject("eXg");
		schedule.setBody("e");
		schedule.setLocation("ꏊ");
		MailAddress TOs[] = new MailAddress[1];
//		TOs[0] = new MailAddress("test@amax.co.jp");
		schedule.setTo(TOs);
		schedule.setResponserequested(true);
		schedule.setMeetingstatus("CONFIRMED");
		scheduleStore.createNewSchedule(acc,schedule);
	}
	
	private void dumpDTO(Exch2kScheduleDTO dto)
	{
		Log.debug("=======================================");
		Log.debug("Subject="+dto.getSubject());
		Log.debug("Location="+dto.getLocation());
		Log.debug("Body="+dto.getBody());
		Log.debug("StartDate="+dto.getStartDate());
		Log.debug("EndDate="+dto.getEndDate());
		Log.debug("Alldayevent="+dto.isAlldayevent());
		Log.debug("Busystatus="+dto.getBusystatus());
		Log.debug("Created="+dto.getCreated());
		Log.debug("Duration="+dto.getDuration());
		Log.debug("Exdate="+Arrays.asList(dto.getExdate()));
		Log.debug("Exrule="+dto.getExrule());
		Log.debug("Instancetype="+dto.getInstancetype());
		Log.debug("Isorganizer="+dto.isIsorganizer());
		Log.debug("Lastmodified="+dto.getLastmodified());
		Log.debug("Lastmodifiedtime="+dto.getLastmodifiedtime());
		Log.debug("Meetingstatus="+dto.getMeetingstatus());
		Log.debug("Organizer="+dto.getOrganizer());
		Log.debug("Rdate="+dto.getRdate());
		Log.debug("Recurrenceid="+dto.getRecurrenceid());
		Log.debug("Reminderoffset="+dto.getReminderoffset());
		Log.debug("Resources="+dto.getResources());
		Log.debug("Sequence="+dto.getSequence());
		Log.debug("Timezone="+dto.getTimezone());
		Log.debug("Timezoneid="+dto.getTimezoneid());
		Log.debug("Uid="+dto.getUid());
		Log.debug("Version="+dto.getVersion());
		Log.debug("To="+Arrays.asList(dto.getTo()));
		Log.debug("Cc="+Arrays.asList(dto.getCc()));
		Log.debug("Bcc="+Arrays.asList(dto.getBcc()));
		Log.debug("Responserequested="+dto.isResponserequested());
		Log.debug("=======================================");
	}
}
