/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.*;

import javax.xml.datatype.XMLGregorianCalendar;

import com.microsoft.schemas.exchange.services._2006.messages.BaseRequestType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateItemType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemType;
import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.*;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.client.ScheduleSearchCondition;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;

public class ExchewsScheduleStoreImpl extends EAIExchewsBase implements IScheduleStore
{
	public static final List<String> SEARCH_FIELDS = IEwsSearchFormula.ALL_PROPERTIES;
	public static final IStoreID storeID = new SimpleStoreID(ExchewsScheduleStoreImpl.class.getName());
	public static final String storeName = "Exchange EWS schedule store";
	protected static final String itemType="IPM.Appointment";
	
	public IServiceInfo getServiceInfo() throws Exception
	{
		return new ExchewsServiceInfo(storeID,storeName);
	}
	
	@Override
	public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception
	{
		return super.getServiceInfo(storeID, storeName, serviceData);
	}

	@Override
	public IObjectIndex createNewSchedule(IAccountData acc, IScheduleDTO dto) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException
	{
		super.setAccountData(acc);

		ItemType item = null;
		try {
			item = ExchewsScheduleDTO.convertToCalendarItemType(dto);
		}
		catch (Exception e) {
			Log.error("ScheduleDTO convert error.", e);
			throw new IncorrectData(e.getMessage());
		}
		item = super.createItem(shceduleElement, item);
		ExchewsObjectIndex oid = new ExchewsObjectIndex(item.getItemId());
		return oid;
	}

	@Override
	protected void setAdditionalRequestProperties(BaseRequestType item) throws HandleException
	{
		if (item==null) return;
		CalendarItemCreateOrDeleteOperationType type;
		if (item instanceof CreateItemType) {
			ItemType it = ((CreateItemType) item).getItems().getItemOrMessageOrCalendarItem().get(0);
			type = CalendarItemCreateOrDeleteOperationType.SEND_TO_NONE;
			if (it!=null) {
				if (it instanceof CalendarItemType) {
					CalendarItemType cal = (CalendarItemType)it;
					if ((cal.getRequiredAttendees()==null) && (cal.getOptionalAttendees()==null)) {
					}
					else {
						type = CalendarItemCreateOrDeleteOperationType.SEND_TO_ALL_AND_SAVE_COPY;
					}
				}
			}
			((CreateItemType) item).setSendMeetingInvitations(type);
		}
		else if (item instanceof UpdateItemType) {
			CalendarItemUpdateOperationType utype = CalendarItemUpdateOperationType.SEND_TO_NONE;
			if (sendFlag) {
				utype = CalendarItemUpdateOperationType.SEND_TO_CHANGED_AND_SAVE_COPY;
				sendFlag = false;
			}
			UpdateItemType ui = (UpdateItemType) item;
			ui.setSendMeetingInvitationsOrCancellations(utype);
		}
	}


	@Override
	public void deleteSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		try {
			delete(acc,null,oid);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			throw new HandleException(e);
		}
	}

	@Override
	public IScheduleDTO[] getAllSchedules(IAccountData acc, Date cutOffDate) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IScheduleDTO getSchedule(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		ISearchDestination dest = this.getPresetDestination(acc, DEST_TYPE_DEFAULT_SCHEDULE_FOLDER);
		CalendarItemType item = (CalendarItemType) getItem(dest,(ItemIdType) oid.getIndex());
		ExchewsScheduleDTO rc = null;
		try {
			rc = ExchewsScheduleDTO.convertFromCalendarItemType(item);
			if (rc!=null) {
				if (item.isHasAttachments().booleanValue()) {
					rc.convertAndSetEWSAttachments(getAttachments(item));
				}
			}
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("Calendar item convert error", e);
			throw new HandleException(e);
		}
		return rc;
	}

	@Override
	public IScheduleDTO[] getSchedulesByDate(IAccountData acc, Date date) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		SearchConditionCollection cond = new SearchConditionCollection();
		ISearchDestination dest = getPresetDestination(acc,IScheduleStore.DEST_TYPE_DEFAULT_SCHEDULE_FOLDER);
		List<String> fieldsToGet = SEARCH_FIELDS;
		EWSSearchFormula form = null;
		try {
			form = new EWSSearchFormula(dest, fieldsToGet, cond);
		}
		catch (Exception e) {
			Log.error("", e);
			throw new HandleException();
		}
		
		return this.getSchedulesByDate(acc, form, date);
	}

	public IScheduleDTO[] getSchedulesByDate(IAccountData acc, ISearchFormula search, Date date) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		SearchConditionCollection cond = super.getDateSearchCondition(UnindexedFieldURIType.CALENDAR_START, date);
		SearchConditionCollection src = search.getSearchConditions();
		if (src==null) {
			search.setSearchConditions(cond);
		}
		else {
			EWS_AND_SearchConditionCollection and = new EWS_AND_SearchConditionCollection();
			and.add(cond);
			and.add(src);
			search.setSearchConditions(and);
		}
		IScheduleDTO[] dtos=new ExchewsScheduleDTO[1];

		List<? extends ItemType> items = new ArrayList<CalendarItemType>();
		try {
			items = super.searchByDate(search.getDest(), (List<String>)search.getFieldsToGet(), search.getSearchConditions(),date,itemType);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("", e);
			throw new HandleException(e);
		}
		ArrayList<ExchewsScheduleDTO> rc = new ArrayList<ExchewsScheduleDTO>();

		for (ItemType item : items) {
			try {
				ExchewsScheduleDTO dto = ExchewsScheduleDTO.convertFromCalendarItemType((CalendarItemType) item);
				rc.add(dto);
				if (item.isHasAttachments().booleanValue()) {
					dto.convertAndSetEWSAttachments(getAttachments(item));
				}
			}
			catch (Exception e) {
				Log.debug("error on converting CalendarItemType to ExchewsScheduleDTO. skip one data..", e);
			}
		}

		return rc.toArray(dtos);
	}

	@Override
	public boolean isDuplicateSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		return false;
	}

	@Override
	public boolean isValidSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		return false;
	}

	@Override
	public IScheduleDTO[] searchSchedules(IAccountData acc, ISearchFormula form) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException
	{
		if (form==null) {
			throw new NullPointerException("ISearchFormula parameter must not be null.");
		}
		SearchConditionCollection conds = form.getSearchConditions();
		if (conds==null) {
			throw new IncorrectData("Search condition for date must be defined.");
		}
		Date date=null;
		ExchewsObjectIndex oid=null;
		for (ISearchConditionElement cond : conds) {
			if (cond == null) continue;
			if (cond instanceof ScheduleSearchCondition) {
				ScheduleSearchCondition con = (ScheduleSearchCondition) cond;
				ISearchType type = con.getType();
				Object value = con.getValue();
				if (type==ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE) {
					date = (Date) value;
				}
				else if (type==ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME) {
					idToSee = (IObjectIndex) value;
				}
				else if (type==ScheduleSearchCondition.CONDITION.TYPE_OID) {
					oid = (ExchewsObjectIndex)value;
				}
			}
		}
//		ISearchDestination dest = form.getDest();
		if (oid != null) {
			IScheduleDTO[] rc = new IScheduleDTO[1];
			rc[0] =getSchedule(acc, oid); 
			return rc;
		}
		if (date==null) {
			throw new IncorrectData("Search condition for date must be defined.");
		}
		return getSchedulesByDate(acc, date);
	}

	@Override
	public IObjectIndex updateSchedule(IAccountData acc, IScheduleDTO dto) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		if (dto==null) {
			throw new IncorrectData("dto null.");
		}
		if (dto.getOid()==null) {
			throw new IncorrectData("oid in updateItem should not be null");
		}
		super.setAccountData(acc);
		IObjectIndex oid = dto.getOid();

		super.updateItem((ItemIdType) oid.getIndex(),generateUpdateMap(dto));

		return oid;
	}

	protected boolean sendFlag=false;
	protected UpdateItemMap generateUpdateMap(IScheduleDTO dto) throws IncorrectData
	{
		if (dto instanceof ExchewsScheduleDTO) {
			ExchewsScheduleDTO sche = (ExchewsScheduleDTO) dto;
			if ((sche.getTo()==null) && (sche.getCc()==null) && (sche.getBcc()==null)) {
				sendFlag=false;
			}
			else {
				sendFlag=true;
			}
		}
		UpdateItemMap map = new UpdateItemMap();
		
		ItemType item = null;
		try {
			item = new ItemType();
			item.setSubject(dto.getSubject());
			map.put(UnindexedFieldURIType.ITEM_SUBJECT, item);
			item = new ItemType();
			BodyType value = new BodyType();
			value.setBodyType(BodyTypeType.TEXT);
			value.setValue(dto.getBody());
			item.setBody(value);
			map.put(UnindexedFieldURIType.ITEM_BODY, item);
			CalendarItemType citem = new CalendarItemType();
			XMLGregorianCalendar sdt = ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getStartDate());
			citem.setStart(sdt );
			map.put(UnindexedFieldURIType.CALENDAR_START, citem);
			citem = new CalendarItemType();
			XMLGregorianCalendar edt = ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getEndDate());
			citem.setEnd(edt);
			map.put(UnindexedFieldURIType.CALENDAR_END, citem);
			citem = new CalendarItemType();
			citem.setLocation(dto.getLocation());
			map.put(UnindexedFieldURIType.CALENDAR_LOCATION, citem);
		}
		catch (Exception e) {
			Log.error("IScheduleDTO convert error.", e);
			throw new IncorrectData(e.getMessage());
		}
		
		return map;
	}

	@Override
	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		super.setAccountData(acc);
		super.sendMailPolicy = CalendarItemCreateOrDeleteOperationType.SEND_TO_ALL_AND_SAVE_COPY;
		super.delete(oid);
	}

	@Override
	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public String getName() throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public ISearchDestination getPresetDestination(IAccountData acc,int type) throws IncorrectData, HandleException
	{
		super.setAccountData((PasswordBasedAccountDataImpl) acc);
		IFolderIndex folder = null;
		IDatabaseIndex db = null;
		DistinguishedFolderIdType src = new DistinguishedFolderIdType();
		switch (type) {
		case DEST_TYPE_DEFAULT_SCHEDULE_FOLDER:
			src.setId(shceduleElement);
			break;
		case DEST_TYPE_OTHERS_SCHEDULEBOX:
			src.setId(shceduleElement);
			break;
		default:
			throw new IncorrectData("illegal folderType");
		}
		folder = (IFolderIndex) populateFolder(new ExchewsFolderIndex(src)).getOid();
		return (ISearchDestination) new BasicSearchDestination(db, folder);
	}

	@Override
	public IStoreID getStoreID() throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception
	{
		if (data.isNew()) {
			return createNewSchedule(acc, (IScheduleDTO)data);
		}
		else {
			return updateSchedule(acc, (IScheduleDTO)data);
		}
	}

	@Override
	protected UnindexedFieldURIType getDateField()
	{
		return UnindexedFieldURIType.CALENDAR_START;
	}

	@Override
	protected TargetFolderIdType getTargetFolder()
	{
		TargetFolderIdType target = new TargetFolderIdType();
		DistinguishedFolderIdType id = new DistinguishedFolderIdType();
		id.setId(shceduleElement);
		target.setDistinguishedFolderId(id);
		return target;
	}

}
