/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import junit.framework.TestCase;

public class TestDateBinarySearch extends TestCase {

    public void testBin() throws Exception {

        SimpleDateFormat f = new SimpleDateFormat("yyy-MM-dd HH:mm:ss Z");
        java.util.List<Date> dates = new java.util.ArrayList<Date>();
        // ----eXgf[^-----
        // 1 : 10-09-23 09:02:00 +0900
        // 2 : 10-09-23 18:02:00 +0900
        // 3 : 10-09-24 22:02:00 +0900
        // 4 : 10-09-25 09:02:00 +0900
        // 5 : 10-09-26 00:00:00 +0900
        // 6 : 10-09-26 00:00:00 +0900
        // 7 : 10-09-26 00:00:00 +0900
        // 8 : 10-09-26 09:02:00 +0900
        // 9 : 10-09-26 11:58:00 +0900
        // 10 : 10-09-26 14:44:00 +0900
        // 11 : 10-09-26 14:55:00 +0900
        // 12 : 10-09-26 16:59:00 +0900
        // 13 : 10-09-26 22:45:32 +0900
        // 14 : 10-09-26 23:59:59 +0900
        // 15 : 10-09-26 23:59:59 +0900
        // 16 : 10-09-27 12:45:32 +0900
        // 17 : 10-09-27 14:01:01 +0900
        // 18 : 10-09-27 23:01:02 +0900
        // ---------
        dates.add(f.parse("2010-09-23 09:02:00 +0900"));
        dates.add(f.parse("2010-09-23 18:02:00 +0900"));
        dates.add(f.parse("2010-09-24 22:02:00 +0900"));
        dates.add(f.parse("2010-09-25 09:02:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 09:02:00 +0900"));
        dates.add(f.parse("2010-09-26 11:58:00 +0900"));
        dates.add(f.parse("2010-09-26 14:44:00 +0900"));
        dates.add(f.parse("2010-09-26 14:55:00 +0900"));
        dates.add(f.parse("2010-09-26 16:59:00 +0900"));
        dates.add(f.parse("2010-09-26 22:45:32 +0900"));
        dates.add(f.parse("2010-09-26 23:59:59 +0900"));
        dates.add(f.parse("2010-09-26 23:59:59 +0900"));
        dates.add(f.parse("2010-09-27 12:45:32 +0900"));
        dates.add(f.parse("2010-09-27 14:01:01 +0900"));
        dates.add(f.parse("2010-09-27 23:01:02 +0900"));
        java.util.Date[] arr = dates.toArray(new java.util.Date[0]);

        System.out.println("----eXgf[^-----");
        int x = 0;
        for (Iterator<Date> i = dates.iterator(); i.hasNext();) {
            Date e = i.next();
            System.out.println("\t" + ++x + " : " + f.format(e));
        }
        System.out.println("---------");

        // begin=t00:00:00, end=t23:59:59̂Ƃ
        // begin>length : ̓t͂Ȃ
        // begin<0 : ̓t͂Ȃ
        // end<0 : ̓t͂Ȃ
        // end<begin : ̓t͂Ȃ
        // ȊO : begin to endł̓t

        Date num = f.parse("2010-09-26 00:00:00 +0900");
        int start = DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER); // 񕪒T
        if (start == -1) {
            System.out.println(num + "͌Ȃł");
        } else {
            System.out.println("arr[" + start + "]Ŕł");
        }

        num = f.parse("2010-09-26 23:59:59 +0900");
        int end = DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER); // 񕪒T
        if (end == -1) {
            System.out.println(num + "͌Ȃł");
        } else {
            System.out.println("arr[" + end + "]Ŕł");
        }

        boolean isThere = DateBinarySearch.checkDataExist(start, end, arr);
        if (isThere) {
            System.out.println("f[^͂܂B");
        } else {
            System.out.println("f[^͂܂B");
        }

        assertEquals("JnF", start, 4);
        assertEquals("IF", end, 14);

        System.out.println("-----͈͂̃f[^----");
        for (Iterator<Date> i = dates.subList(start, end + 1).iterator(); i.hasNext();) {
            Date e = i.next();
            System.out.println("\t" + f.format(e));
        }
        System.out.println("---------");

        num = f.parse("2010-09-23 09:02:00 +0900");
        assertEquals("擪:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 0);
        assertEquals("擪:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 0);

        num = f.parse("2010-09-27 23:01:02 +0900");
        assertEquals("[:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 17);
        assertEquals("[:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 17);

        num = f.parse("2010-09-26 09:02:00 +0900");
        assertEquals(":P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 7);
        assertEquals(":P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 7);

        num = f.parse("2010-09-23 18:02:00 +0900");
        assertEquals("ォQԖ:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 1);
        assertEquals("ォQԖ:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 1);

        num = f.parse("2010-09-27 14:01:01 +0900");
        assertEquals("QԖ:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 16);
        assertEquals("QԖ:P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 16);

    }

    public void testBinDuplication() throws Exception {

        SimpleDateFormat f = new SimpleDateFormat("yyy-MM-dd HH:mm:ss Z");
        java.util.List<Date> dates = new java.util.ArrayList<Date>();
        // 1 : 10-09-23 18:02:00 +0900
        // 2 : 10-09-23 18:02:00 +0900
        // 3 : 10-09-23 18:02:00 +0900
        // 4 : 10-09-24 22:02:00 +0900
        // 5 : 10-09-25 09:02:00 +0900
        // 6 : 10-09-26 00:00:00 +0900
        // 7 : 10-09-26 00:00:00 +0900
        // 8 : 10-09-26 00:00:00 +0900
        // 9 : 10-09-26 09:02:00 +0900
        // 10 : 10-09-26 11:58:00 +0900
        // 11 : 10-09-26 11:58:00 +0900
        // 12 : 10-09-26 11:58:00 +0900
        // 13 : 10-09-26 14:44:00 +0900
        // 14 : 10-09-26 14:55:00 +0900
        // 15 : 10-09-26 22:45:32 +0900
        // 16 : 10-09-26 23:59:59 +0900
        // 17 : 10-09-27 23:01:02 +0900
        // 18 : 10-09-27 23:01:02 +0900
        dates.add(f.parse("2010-09-23 18:02:00 +0900"));
        dates.add(f.parse("2010-09-23 18:02:00 +0900"));
        dates.add(f.parse("2010-09-23 18:02:00 +0900"));
        dates.add(f.parse("2010-09-24 22:02:00 +0900"));
        dates.add(f.parse("2010-09-25 09:02:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 00:00:00 +0900"));
        dates.add(f.parse("2010-09-26 09:02:00 +0900"));
        dates.add(f.parse("2010-09-26 11:58:00 +0900"));
        dates.add(f.parse("2010-09-26 11:58:00 +0900"));
        dates.add(f.parse("2010-09-26 11:58:00 +0900"));
        dates.add(f.parse("2010-09-26 14:44:00 +0900"));
        dates.add(f.parse("2010-09-26 14:55:00 +0900"));
        dates.add(f.parse("2010-09-26 22:45:32 +0900"));
        dates.add(f.parse("2010-09-26 23:59:59 +0900"));
        dates.add(f.parse("2010-09-27 23:01:02 +0900"));
        dates.add(f.parse("2010-09-27 23:01:02 +0900"));
        java.util.Date[] arr = dates.toArray(new java.util.Date[0]);

        System.out.println("----eXgf[^-----");
        int x = 0;
        for (Iterator<Date> i = dates.iterator(); i.hasNext();) {
            Date e = i.next();
            System.out.println("\t" + ++x + " : " + f.format(e));
        }
        System.out.println("---------");

        Date num;
        num = f.parse("2010-09-23 18:02:00 +0900");
        assertEquals("擪:d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 2);
        assertEquals("擪:d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 0);

        num = f.parse("2010-09-27 23:01:02 +0900");
        assertEquals("[:d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 17);
        assertEquals("[:d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 16);

        num = f.parse("2010-09-26 14:44:00 +0900");
        assertEquals(":P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 12);
        assertEquals(":P:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 12);

        num = f.parse("2010-09-26 11:58:00 +0900");
        assertEquals(":d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.LESSER), 11);
        assertEquals(":d:ʁF", DateBinarySearch.binarySearch(arr, num, DateBinarySearch.MODE.GREATER), 9);

    }
}
