package jp.cssj.driver.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Map;

import jp.cssj.cti2.CTIDriver;
import jp.cssj.cti2.CTISession;

/**
 * <p>
 * HTTP/REST通信を利用するドライバです。
 * </p>
 * <p>
 * URIの形式は <tt>http://ホスト名:ポート番号/</tt> です。
 * </p>
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CTIPDriver.java 287 2009-07-13 13:35:23Z miyabe $
 */
public class RestDriver implements CTIDriver {
	public boolean match(Object key) {
		URI uri = (URI) key;
		if (uri == null) {
			return false;
		}
		// http:またはhttps:で始まる透明URI
		return !uri.isOpaque()
				&& ("http".equals(uri.getScheme()) || "https".equals(uri
						.getScheme()));
	}

	public CTISession getSession(URI uri, Map props) throws IOException {
		String user = null, password = null;
		if (props != null) {
			user = (String) props.get("user");
			password = (String) props.get("password");
		}
		return new RestSession(uri, user, password);
	}
}