/*

 Copyright 2001  The Apache Software Foundation 

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package net.zamasoft.font.table;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

/**
 * @version $Id: CmapFormat.java 615 2011-08-28 07:31:32Z miyabe $
 * @author <a href="mailto:david@steadystate.co.uk">David Schweinsberg</a>
 */
public abstract class CmapFormat implements Serializable {
	private static final long serialVersionUID = 0L;

	protected int format;

	protected int length;

	protected int version;

	protected CmapFormat(DataInputStream in) throws IOException {
		this.length = in.readUnsignedShort();
		this.version = in.readUnsignedShort();
	}

	protected static CmapFormat create(int format, DataInputStream in)
			throws IOException {
		switch (format) {
		case 0:
			return new CmapFormat0(in);
		case 2:
			return new CmapFormat2(in);
		case 4:
			return new CmapFormat4(in);
		case 6:
			return new CmapFormat6(in);
		}
		return null;
	}

	public int getFormat() {
		return this.format;
	}

	public int getLength() {
		return this.length;
	}

	public int getVersion() {
		return this.version;
	}

	public abstract int mapCharCode(int charCode);

	public abstract int getFirst();

	public abstract int getLast();

	public String toString() {
		return new StringBuffer().append("format: ").append(this.format)
				.append(", length: ").append(this.length).append(", version: ")
				.append(this.version).toString();
	}
}
