package jp.cssj.cr.compat;

import java.io.Serializable;

import android.graphics.Matrix;

public class XMatrix extends Matrix implements Serializable {
	private static final long serialVersionUID = 0L;

	public XMatrix() {
		super();
	}

	final float[] temp = new float[9];

	public XMatrix(double sx, double m10, double m01, double sy, double tx,
			double ty) {
		this.setValues(new float[] { (float) sx, (float) m10, (float) tx,
				(float) sy, (float) m01, (float) ty, 0, 0, 1 });
	}

	public XMatrix(Matrix m) {
		super(m);
	}

	public static XMatrix getTranslateInstance(double dx, double dy) {
		XMatrix matrix = new XMatrix();
		matrix.setTranslate((float) dx, (float) dy);
		return matrix;
	}

	public static XMatrix getScaleInstance(double dx, double dy) {
		XMatrix matrix = new XMatrix();
		matrix.setScale((float) dx, (float) dy);
		return matrix;
	}

	public static XMatrix getShearInstance(double sx, double sy) {
		return new XMatrix(1, sy, sx, 1, 0, 0);
	}

	public static XMatrix getRotateInstance(double r) {
		XMatrix matrix = new XMatrix();
		matrix.setRotate((float) (r * 180 / Math.PI));
		return matrix;
	}

	public void scale(double sx, double sy) {
		this.preScale((float) sx, (float) sy);
	}

	public void shear(double sx, double sy) {
		this.preConcat(getShearInstance(sx, sy));
	}

	public void translate(double dx, double dy) {
		this.preTranslate((float) dx, (float) dy);
	}

	public void rotate(double t) {
		this.preRotate((float) (t * 180f / Math.PI));
	}

	public void concatenate(XMatrix m) {
		this.postConcat(m);
	}

	public XPointF transform(XPointF src, XPointF dest) {
		float[] s = { src.x, src.y };
		float[] d = new float[2];
		this.mapPoints(d, s);
		if (dest == null) {
			dest = new XPointF(d[0], d[1]);
		} else {
			dest.set(d[0], d[1]);
		}
		return dest;
	}

	public XRectF createTransformedXRectF(XRectF rect) {
		XRectF dest = new XRectF(0, 0, 0, 0);
		this.mapRect(dest, rect);
		return rect;
	}

	public synchronized float getScaleX() {
		this.getValues(this.temp);
		return this.temp[Matrix.MSCALE_X];
	}

	public synchronized float getScaleY() {
		this.getValues(this.temp);
		return this.temp[Matrix.MSCALE_Y];
	}
}
