package jp.cssj.cr.gc;

import java.io.IOException;
import java.io.InputStream;

import jp.cssj.cr.epub.Cache;
import jp.cssj.resolver.Source;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.image.Image;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public class AndroidImage implements Image {
	protected Source source;
	protected Drawable drawable;
	protected Cache cache;
	protected double width, height;

	public AndroidImage(Source source, Cache cache) throws IOException {
		this.source = source;
		this.cache = cache;
		this.load();
	}

	public synchronized boolean available() {
		return this.drawable != null;
	}

	public synchronized boolean free() {
		if (this.drawable == null) {
			return false;
		}
		this.drawable = null;
		return true;
	}

	public synchronized void load() throws IOException {
		this.cache.free();
		for (;;) {
			InputStream in = this.source.getInputStream();
			try {
				Bitmap bitmap = BitmapFactory.decodeStream(in);
				this.drawable = new BitmapDrawable(bitmap);
				this.width = bitmap.getWidth();
				this.height = bitmap.getHeight();
				break;
			} catch (OutOfMemoryError e) {
				if (this.cache.forceFree()) {
					continue;
				}
				throw e;
			} finally {
				in.close();
			}
		}
		if (this.drawable == null) {
			throw new NullPointerException();
		}
	}

	public synchronized Drawable getDrawable() {
		if (this.drawable == null) {
			try {
				this.load();
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return this.drawable;
	}

	public void drawTo(GC gc) throws GraphicsException {
		gc.drawImage(this);
	}

	public String getAltString() {
		return null;
	}

	public synchronized double getWidth() {
		this.getDrawable();
		return this.width;
	}

	public synchronized double getHeight() {
		this.getDrawable();
		return this.height;
	}

}
