package jp.cssj.cr.gc;

import java.io.IOException;

import jp.cssj.homare.css.CSSElement;
import jp.cssj.homare.style.imposition.Imposition;
import jp.cssj.homare.ua.UserAgent;
import jp.cssj.homare.ua.props.OutputPrintMode;
import jp.cssj.homare.ua.props.UAProps;
import jp.cssj.sakae.GCConstants;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;

public class SinglePageImposition implements Imposition {
	protected final UserAgent ua;

	protected int pageNumber = 0;

	protected byte boundSide = BOUND_SIDE_LEFT;

	protected byte printMode;

	protected byte align = ALIGN_CENTER;
	/** ページ幅。 */
	protected double pageWidth = (GCConstants.PAPER_A4_WIDTH_MM * GCConstants.POINTS_PER_MM);

	/** ページ高さ。 */
	protected double pageHeight = (GCConstants.PAPER_A4_HEIGHT_MM * GCConstants.POINTS_PER_MM);

	protected GC gc;

	public SinglePageImposition(UserAgent ua) {
		assert ua != null;
		this.ua = ua;
		this.printMode = (byte) UAProps.OUTPUT_PRINT_MODE.getCode(ua);
	}

	public final byte getBoundSide() {
		return this.boundSide;
	}

	public final void setBoundSide(byte boundSide) {
		this.boundSide = boundSide;
	}

	public final byte getAlign() {
		return this.align;
	}

	public final void setAlign(byte align) {
		this.align = align;
	}

	public byte getAutoRotate() {
		// ignore
		return 0;
	}

	public void setAutoRotate(byte autoRotate) {
		// ignore
	}

	public final double getHTrim() {
		return 0;
	}

	public final void setHTrim(double htrim) {
		//
	}

	public final double getVTrim() {
		return 0;
	}

	public final void setVTrim(double vtrim) {
		//
	}

	public final double getCuttingMargin() {
		return 0;
	}

	public final void setCuttingMargin(double cuttingMargin) {
		//
	}

	public final double getSpineWidth() {
		return 0;
	}

	public final void setSpineWidth(double spineWidth) {
		//
	}

	public final double getPageWidth() {
		return this.pageWidth;
	}

	public final void setPageWidth(double pageWidth) {
		this.pageWidth = pageWidth;
	}

	public void fitPaperWidth() {
		//
	}

	public final double getPageHeight() {
		return this.pageHeight;
	}

	public final void setPageHeight(double pageHeight) {
		this.pageHeight = pageHeight;
	}

	public void fitPaperHeight() {
		//
	}

	public final double getPaperWidth() {
		return this.pageWidth;
	}

	public final void setPaperWidth(double paperWidth) {
		//
	}

	public final double getPaperHeight() {
		return this.pageHeight;
	}

	public final void setPaperHeight(double paperHeight) {
		//
	}

	public final String getNote() {
		return "";
	}

	public final void setNote(String note) {
		//
	}

	public final boolean isCrop() {
		return false;
	}

	public final void setCrop(boolean crop) {
		//
	}

	public final boolean isCross() {
		return false;
	}

	public final void setCross(boolean cross) {
		//
	}

	public final boolean isClip() {
		return false;
	}

	public final void setClip(boolean clip) {
		//
	}

	public GC nextPage() throws GraphicsException {
		++this.pageNumber;
		this.gc = this.ua.nextPage(this.pageWidth, this.pageHeight);
		this.gc.begin();
		return this.gc;
	}

	public CSSElement nextPageSide() {
		CSSElement pageElement = this.ua.getPassContext().getPageSide();
		switch (this.printMode) {
		case OutputPrintMode.DOUBLE_SIDE:
		case OutputPrintMode.LEFT_SIDE:
		case OutputPrintMode.RIGHT_SIDE:
			// 両面
			if (this.getBoundSide() == Imposition.BOUND_SIDE_LEFT) {
				// 横書き
				if (pageElement == null) {
					pageElement = CSSElement.PAGE_FIRST_RIGHT;
				} else if (pageElement == CSSElement.PAGE_FIRST_RIGHT) {
					pageElement = CSSElement.PAGE_LEFT_EVEN;
				} else if (pageElement == CSSElement.PAGE_LEFT_EVEN) {
					pageElement = CSSElement.PAGE_RIGHT_ODD;
				} else if (pageElement == CSSElement.PAGE_RIGHT_ODD) {
					pageElement = CSSElement.PAGE_LEFT_EVEN;
				}
			} else {
				// 縦書き
				if (pageElement == null) {
					pageElement = CSSElement.PAGE_FIRST_LEFT;
				} else if (pageElement == CSSElement.PAGE_FIRST_LEFT) {
					pageElement = CSSElement.PAGE_RIGHT_EVEN;
				} else if (pageElement == CSSElement.PAGE_RIGHT_EVEN) {
					pageElement = CSSElement.PAGE_LEFT_ODD;
				} else if (pageElement == CSSElement.PAGE_LEFT_ODD) {
					pageElement = CSSElement.PAGE_RIGHT_EVEN;
				}
			}
			break;

		case OutputPrintMode.SINGLE_SIDE:
			// 片面
			if (pageElement == null) {
				pageElement = CSSElement.PAGE_SINGLE_FIRST;
			} else {
				pageElement = CSSElement.PAGE_SINGLE;
			}
			break;

		default:
			throw new IllegalStateException();
		}
		this.ua.getPassContext().setPageSide(pageElement);
		return pageElement;
	}

	public void closePage() throws GraphicsException {
		this.gc.end();
		try {
			this.ua.closePage(this.gc);
		} catch (IOException e) {
			throw new GraphicsException(e);
		} finally {
			this.gc = null;
		}
	}

	public void finish() throws GraphicsException {
		// ignore
	}
}
